LOCAL_PATH := $(call my-dir)

# Add prebuilt libopenxr_loader library
include $(CLEAR_VARS)
LOCAL_MODULE := openxr_loader
LOCAL_SRC_FILES := $(LOCAL_PATH)/../deps/OpenXR/Pico4/lib/libopenxr_loader.so
include $(PREBUILT_SHARED_LIBRARY)

# Add library
include $(CLEAR_VARS)
LOCAL_MODULE := shr3d
LOCAL_CFLAGS += -DPLATFORM_PICO_4
LOCAL_C_INCLUDES += $(LOCAL_PATH)/../deps/OpenXR/Pico4/include
LOCAL_C_INCLUDES += $(LOCAL_PATH)/../src
LOCAL_SRC_FILES := ../src/asio.cpp \
../src/backup.cpp \
../src/base64.cpp \
../src/camera.cpp \
../src/collection.cpp \
../src/coop.cpp \
../src/data.cpp \
../src/debug.cpp \
../src/file.cpp \
../src/font.cpp \
../src/geometry.cpp \
../src/getopt.cpp \
../src/global.cpp \
../src/glsl.cpp \
../src/helper.cpp \
../src/hexfin.c \
../src/highway.cpp \
../src/highway2.cpp \
../src/hud.cpp \
../src/hud2.cpp \
../src/inflate.cpp \
../src/ini.cpp \
../src/input.cpp \
../src/json.cpp \
../src/main.cpp \
../src/midi.cpp \
../src/milk.cpp \
../src/miniz.cpp \
../src/nuklear.cpp \
../src/ogg.cpp \
../src/opengl.cpp \
../src/openxr.cpp \
../src/openxr_pico4.cpp \
../src/openxr_quest3.cpp \
../src/particle.cpp \
../src/pcm.cpp \
../src/player.cpp \
../src/png.cpp \
../src/psarc.cpp \
../src/recorder.cpp \
../src/revorb.cpp \
../src/rijndael.cpp \
../src/samplerate.c \
../src/sampleratesrc_linear.c \
../src/sampleratesrc_sinc.c \
../src/sampleratesrc_zoh.c \
../src/settings.cpp \
../src/sfx.cpp \
../src/sfxCore.cpp \
../src/sfxPluginClap.cpp \
../src/sfxPluginLV2.cpp \
../src/sfxPluginVst.cpp \
../src/sfxPluginVst3.cpp \
../src/shader.cpp \
../src/shred.cpp \
../src/skybox.cpp \
../src/sng.cpp \
../src/song.cpp \
../src/sound.cpp \
../src/spirv.cpp \
../src/spotify.cpp \
../src/stage.cpp \
../src/stats.cpp \
../src/stretcher.cpp \
../src/string_.cpp \
../src/test.cpp \
../src/texture.cpp \
../src/tones.cpp \
../src/tunerThread.cpp \
../src/ui.cpp \
../src/wem.cpp \
../src/window.cpp \
../src/xr.cpp \
#../src/sfxCore/airWindows/sfxCoreAirWindows.cpp \
#../src/sfxCore/airWindows/common/airwin_consolidated_base.cpp \
#../src/sfxCore/airWindows/effects/Acceleration.cpp \
#../src/sfxCore/airWindows/effects/Acceleration2.cpp \
#../src/sfxCore/airWindows/effects/Acceleration2Proc.cpp \
#../src/sfxCore/airWindows/effects/AccelerationProc.cpp \
#../src/sfxCore/airWindows/effects/ADClip7.cpp \
#../src/sfxCore/airWindows/effects/ADClip7Proc.cpp \
#../src/sfxCore/airWindows/effects/ADClip8.cpp \
#../src/sfxCore/airWindows/effects/ADClip8Proc.cpp \
#../src/sfxCore/airWindows/effects/ADT.cpp \
#../src/sfxCore/airWindows/effects/ADTProc.cpp \
#../src/sfxCore/airWindows/effects/Air.cpp \
#../src/sfxCore/airWindows/effects/Air2.cpp \
#../src/sfxCore/airWindows/effects/Air2Proc.cpp \
#../src/sfxCore/airWindows/effects/Air3.cpp \
#../src/sfxCore/airWindows/effects/Air3Proc.cpp \
#../src/sfxCore/airWindows/effects/AirProc.cpp \
#../src/sfxCore/airWindows/effects/Apicolypse.cpp \
#../src/sfxCore/airWindows/effects/ApicolypseProc.cpp \
#../src/sfxCore/airWindows/effects/AQuickVoiceClip.cpp \
#../src/sfxCore/airWindows/effects/AQuickVoiceClipProc.cpp \
#../src/sfxCore/airWindows/effects/AtmosphereBuss.cpp \
#../src/sfxCore/airWindows/effects/AtmosphereBussProc.cpp \
#../src/sfxCore/airWindows/effects/AtmosphereChannel.cpp \
#../src/sfxCore/airWindows/effects/AtmosphereChannelProc.cpp \
#../src/sfxCore/airWindows/effects/Aura.cpp \
#../src/sfxCore/airWindows/effects/AuraProc.cpp \
#../src/sfxCore/airWindows/effects/AutoPan.cpp \
#../src/sfxCore/airWindows/effects/AutoPanProc.cpp \
#../src/sfxCore/airWindows/effects/Average.cpp \
#../src/sfxCore/airWindows/effects/AverageProc.cpp \
#../src/sfxCore/airWindows/effects/AverMatrix.cpp \
#../src/sfxCore/airWindows/effects/AverMatrixProc.cpp \
#../src/sfxCore/airWindows/effects/Balanced.cpp \
#../src/sfxCore/airWindows/effects/BalancedProc.cpp \
#../src/sfxCore/airWindows/effects/BassAmp.cpp \
#../src/sfxCore/airWindows/effects/BassAmpProc.cpp \
#../src/sfxCore/airWindows/effects/BassDrive.cpp \
#../src/sfxCore/airWindows/effects/BassDriveProc.cpp \
#../src/sfxCore/airWindows/effects/BassKit.cpp \
#../src/sfxCore/airWindows/effects/BassKitProc.cpp \
#../src/sfxCore/airWindows/effects/Baxandall.cpp \
#../src/sfxCore/airWindows/effects/Baxandall2.cpp \
#../src/sfxCore/airWindows/effects/Baxandall2Proc.cpp \
#../src/sfxCore/airWindows/effects/BaxandallProc.cpp \
#../src/sfxCore/airWindows/effects/Beam.cpp \
#../src/sfxCore/airWindows/effects/BeamProc.cpp \
#../src/sfxCore/airWindows/effects/BigAmp.cpp \
#../src/sfxCore/airWindows/effects/BigAmpProc.cpp \
#../src/sfxCore/airWindows/effects/Biquad.cpp \
#../src/sfxCore/airWindows/effects/Biquad2.cpp \
#../src/sfxCore/airWindows/effects/Biquad2Proc.cpp \
#../src/sfxCore/airWindows/effects/BiquadDouble.cpp \
#../src/sfxCore/airWindows/effects/BiquadDoubleProc.cpp \
#../src/sfxCore/airWindows/effects/BiquadHiLo.cpp \
#../src/sfxCore/airWindows/effects/BiquadHiLoProc.cpp \
#../src/sfxCore/airWindows/effects/BiquadNonLin.cpp \
#../src/sfxCore/airWindows/effects/BiquadNonLinProc.cpp \
#../src/sfxCore/airWindows/effects/BiquadOneHalf.cpp \
#../src/sfxCore/airWindows/effects/BiquadOneHalfProc.cpp \
#../src/sfxCore/airWindows/effects/BiquadPlus.cpp \
#../src/sfxCore/airWindows/effects/BiquadPlusProc.cpp \
#../src/sfxCore/airWindows/effects/BiquadProc.cpp \
#../src/sfxCore/airWindows/effects/BiquadStack.cpp \
#../src/sfxCore/airWindows/effects/BiquadStackProc.cpp \
#../src/sfxCore/airWindows/effects/BiquadTriple.cpp \
#../src/sfxCore/airWindows/effects/BiquadTripleProc.cpp \
#../src/sfxCore/airWindows/effects/Bite.cpp \
#../src/sfxCore/airWindows/effects/BiteProc.cpp \
#../src/sfxCore/airWindows/effects/BitGlitter.cpp \
#../src/sfxCore/airWindows/effects/BitGlitterProc.cpp \
#../src/sfxCore/airWindows/effects/BitShiftGain.cpp \
#../src/sfxCore/airWindows/effects/BitShiftGainProc.cpp \
#../src/sfxCore/airWindows/effects/BitShiftPan.cpp \
#../src/sfxCore/airWindows/effects/BitShiftPanProc.cpp \
#../src/sfxCore/airWindows/effects/BlockParty.cpp \
#../src/sfxCore/airWindows/effects/BlockPartyProc.cpp \
#../src/sfxCore/airWindows/effects/BrassRider.cpp \
#../src/sfxCore/airWindows/effects/BrassRiderProc.cpp \
#../src/sfxCore/airWindows/effects/BrightAmbience.cpp \
#../src/sfxCore/airWindows/effects/BrightAmbience2.cpp \
#../src/sfxCore/airWindows/effects/BrightAmbience2Proc.cpp \
#../src/sfxCore/airWindows/effects/BrightAmbience3.cpp \
#../src/sfxCore/airWindows/effects/BrightAmbience3Proc.cpp \
#../src/sfxCore/airWindows/effects/BrightAmbienceProc.cpp \
#../src/sfxCore/airWindows/effects/BuildATPDF.cpp \
#../src/sfxCore/airWindows/effects/BuildATPDFProc.cpp \
#../src/sfxCore/airWindows/effects/BussColors4.cpp \
#../src/sfxCore/airWindows/effects/BussColors4Proc.cpp \
#../src/sfxCore/airWindows/effects/ButterComp.cpp \
#../src/sfxCore/airWindows/effects/ButterComp2.cpp \
#../src/sfxCore/airWindows/effects/ButterComp2Proc.cpp \
#../src/sfxCore/airWindows/effects/ButterCompProc.cpp \
#../src/sfxCore/airWindows/effects/C5RawBuss.cpp \
#../src/sfxCore/airWindows/effects/C5RawBussProc.cpp \
#../src/sfxCore/airWindows/effects/C5RawChannel.cpp \
#../src/sfxCore/airWindows/effects/C5RawChannelProc.cpp \
#../src/sfxCore/airWindows/effects/Cabs.cpp \
#../src/sfxCore/airWindows/effects/CabsProc.cpp \
#../src/sfxCore/airWindows/effects/Calibre.cpp \
#../src/sfxCore/airWindows/effects/CalibreProc.cpp \
#../src/sfxCore/airWindows/effects/Capacitor.cpp \
#../src/sfxCore/airWindows/effects/Capacitor2.cpp \
#../src/sfxCore/airWindows/effects/Capacitor2Proc.cpp \
#../src/sfxCore/airWindows/effects/CapacitorProc.cpp \
#../src/sfxCore/airWindows/effects/Chamber.cpp \
#../src/sfxCore/airWindows/effects/Chamber2.cpp \
#../src/sfxCore/airWindows/effects/Chamber2Proc.cpp \
#../src/sfxCore/airWindows/effects/ChamberProc.cpp \
#../src/sfxCore/airWindows/effects/Channel4.cpp \
#../src/sfxCore/airWindows/effects/Channel4Proc.cpp \
#../src/sfxCore/airWindows/effects/Channel5.cpp \
#../src/sfxCore/airWindows/effects/Channel5Proc.cpp \
#../src/sfxCore/airWindows/effects/Channel6.cpp \
#../src/sfxCore/airWindows/effects/Channel6Proc.cpp \
#../src/sfxCore/airWindows/effects/Channel7.cpp \
#../src/sfxCore/airWindows/effects/Channel7Proc.cpp \
#../src/sfxCore/airWindows/effects/Channel8.cpp \
#../src/sfxCore/airWindows/effects/Channel8Proc.cpp \
#../src/sfxCore/airWindows/effects/Channel9.cpp \
#../src/sfxCore/airWindows/effects/Channel9Proc.cpp \
#../src/sfxCore/airWindows/effects/Chorus.cpp \
#../src/sfxCore/airWindows/effects/ChorusEnsemble.cpp \
#../src/sfxCore/airWindows/effects/ChorusEnsembleProc.cpp \
#../src/sfxCore/airWindows/effects/ChorusProc.cpp \
#../src/sfxCore/airWindows/effects/ChromeOxide.cpp \
#../src/sfxCore/airWindows/effects/ChromeOxideProc.cpp \
#../src/sfxCore/airWindows/effects/Cider.cpp \
#../src/sfxCore/airWindows/effects/CiderProc.cpp \
#../src/sfxCore/airWindows/effects/ClearCoat.cpp \
#../src/sfxCore/airWindows/effects/ClearCoatProc.cpp \
#../src/sfxCore/airWindows/effects/ClipOnly2.cpp \
#../src/sfxCore/airWindows/effects/ClipOnly2Proc.cpp \
#../src/sfxCore/airWindows/effects/ClipSoftly.cpp \
#../src/sfxCore/airWindows/effects/ClipSoftlyProc.cpp \
#../src/sfxCore/airWindows/effects/CloudCoat.cpp \
#../src/sfxCore/airWindows/effects/CloudCoatProc.cpp \
#../src/sfxCore/airWindows/effects/Coils.cpp \
#../src/sfxCore/airWindows/effects/Coils2.cpp \
#../src/sfxCore/airWindows/effects/Coils2Proc.cpp \
#../src/sfxCore/airWindows/effects/CoilsProc.cpp \
#../src/sfxCore/airWindows/effects/Cojones.cpp \
#../src/sfxCore/airWindows/effects/CojonesProc.cpp \
#../src/sfxCore/airWindows/effects/Compresaturator.cpp \
#../src/sfxCore/airWindows/effects/CompresaturatorProc.cpp \
#../src/sfxCore/airWindows/effects/Console0Buss.cpp \
#../src/sfxCore/airWindows/effects/Console0BussProc.cpp \
#../src/sfxCore/airWindows/effects/Console0Channel.cpp \
#../src/sfxCore/airWindows/effects/Console0ChannelProc.cpp \
#../src/sfxCore/airWindows/effects/Console4Buss.cpp \
#../src/sfxCore/airWindows/effects/Console4BussProc.cpp \
#../src/sfxCore/airWindows/effects/Console4Channel.cpp \
#../src/sfxCore/airWindows/effects/Console4ChannelProc.cpp \
#../src/sfxCore/airWindows/effects/Console5Buss.cpp \
#../src/sfxCore/airWindows/effects/Console5BussProc.cpp \
#../src/sfxCore/airWindows/effects/Console5Channel.cpp \
#../src/sfxCore/airWindows/effects/Console5ChannelProc.cpp \
#../src/sfxCore/airWindows/effects/Console5DarkCh.cpp \
#../src/sfxCore/airWindows/effects/Console5DarkChProc.cpp \
#../src/sfxCore/airWindows/effects/Console6Buss.cpp \
#../src/sfxCore/airWindows/effects/Console6BussProc.cpp \
#../src/sfxCore/airWindows/effects/Console6Channel.cpp \
#../src/sfxCore/airWindows/effects/Console6ChannelProc.cpp \
#../src/sfxCore/airWindows/effects/Console7Buss.cpp \
#../src/sfxCore/airWindows/effects/Console7BussProc.cpp \
#../src/sfxCore/airWindows/effects/Console7Cascade.cpp \
#../src/sfxCore/airWindows/effects/Console7CascadeProc.cpp \
#../src/sfxCore/airWindows/effects/Console7Channel.cpp \
#../src/sfxCore/airWindows/effects/Console7ChannelProc.cpp \
#../src/sfxCore/airWindows/effects/Console7Crunch.cpp \
#../src/sfxCore/airWindows/effects/Console7CrunchProc.cpp \
#../src/sfxCore/airWindows/effects/Console8BussHype.cpp \
#../src/sfxCore/airWindows/effects/Console8BussHypeProc.cpp \
#../src/sfxCore/airWindows/effects/Console8BussIn.cpp \
#../src/sfxCore/airWindows/effects/Console8BussInProc.cpp \
#../src/sfxCore/airWindows/effects/Console8BussOut.cpp \
#../src/sfxCore/airWindows/effects/Console8BussOutProc.cpp \
#../src/sfxCore/airWindows/effects/Console8ChannelHype.cpp \
#../src/sfxCore/airWindows/effects/Console8ChannelHypeProc.cpp \
#../src/sfxCore/airWindows/effects/Console8ChannelIn.cpp \
#../src/sfxCore/airWindows/effects/Console8ChannelInProc.cpp \
#../src/sfxCore/airWindows/effects/Console8ChannelOut.cpp \
#../src/sfxCore/airWindows/effects/Console8ChannelOutProc.cpp \
#../src/sfxCore/airWindows/effects/Console8LiteBuss.cpp \
#../src/sfxCore/airWindows/effects/Console8LiteBussProc.cpp \
#../src/sfxCore/airWindows/effects/Console8LiteChannel.cpp \
#../src/sfxCore/airWindows/effects/Console8LiteChannelProc.cpp \
#../src/sfxCore/airWindows/effects/Console8SubHype.cpp \
#../src/sfxCore/airWindows/effects/Console8SubHypeProc.cpp \
#../src/sfxCore/airWindows/effects/Console8SubIn.cpp \
#../src/sfxCore/airWindows/effects/Console8SubInProc.cpp \
#../src/sfxCore/airWindows/effects/Console8SubOut.cpp \
#../src/sfxCore/airWindows/effects/Console8SubOutProc.cpp \
#../src/sfxCore/airWindows/effects/Console9Buss.cpp \
#../src/sfxCore/airWindows/effects/Console9BussProc.cpp \
#../src/sfxCore/airWindows/effects/Console9Channel.cpp \
#../src/sfxCore/airWindows/effects/Console9ChannelProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleLABuss.cpp \
#../src/sfxCore/airWindows/effects/ConsoleLABussProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleLAChannel.cpp \
#../src/sfxCore/airWindows/effects/ConsoleLAChannelProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleMCBuss.cpp \
#../src/sfxCore/airWindows/effects/ConsoleMCBussProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleMCChannel.cpp \
#../src/sfxCore/airWindows/effects/ConsoleMCChannelProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleMDBuss.cpp \
#../src/sfxCore/airWindows/effects/ConsoleMDBussProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleMDChannel.cpp \
#../src/sfxCore/airWindows/effects/ConsoleMDChannelProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleXBuss.cpp \
#../src/sfxCore/airWindows/effects/ConsoleXBussProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleXChannel.cpp \
#../src/sfxCore/airWindows/effects/ConsoleXChannelProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleXSubIn.cpp \
#../src/sfxCore/airWindows/effects/ConsoleXSubInProc.cpp \
#../src/sfxCore/airWindows/effects/ConsoleXSubOut.cpp \
#../src/sfxCore/airWindows/effects/ConsoleXSubOutProc.cpp \
#../src/sfxCore/airWindows/effects/ContentHideD.cpp \
#../src/sfxCore/airWindows/effects/ContentHideDProc.cpp \
#../src/sfxCore/airWindows/effects/CreamCoat.cpp \
#../src/sfxCore/airWindows/effects/CreamCoatProc.cpp \
#../src/sfxCore/airWindows/effects/Creature.cpp \
#../src/sfxCore/airWindows/effects/CreatureProc.cpp \
#../src/sfxCore/airWindows/effects/CrickBass.cpp \
#../src/sfxCore/airWindows/effects/CrickBassProc.cpp \
#../src/sfxCore/airWindows/effects/CrunchCoat.cpp \
#../src/sfxCore/airWindows/effects/CrunchCoatProc.cpp \
#../src/sfxCore/airWindows/effects/CrunchyGrooveWear.cpp \
#../src/sfxCore/airWindows/effects/CrunchyGrooveWearProc.cpp \
#../src/sfxCore/airWindows/effects/Crystal.cpp \
#../src/sfxCore/airWindows/effects/CrystalProc.cpp \
#../src/sfxCore/airWindows/effects/CStrip.cpp \
#../src/sfxCore/airWindows/effects/CStrip2.cpp \
#../src/sfxCore/airWindows/effects/CStrip2Proc.cpp \
#../src/sfxCore/airWindows/effects/CStripProc.cpp \
#../src/sfxCore/airWindows/effects/curve.cpp \
#../src/sfxCore/airWindows/effects/curveProc.cpp \
#../src/sfxCore/airWindows/effects/Dark.cpp \
#../src/sfxCore/airWindows/effects/DarkNoise.cpp \
#../src/sfxCore/airWindows/effects/DarkNoiseProc.cpp \
#../src/sfxCore/airWindows/effects/DarkProc.cpp \
#../src/sfxCore/airWindows/effects/DCVoltage.cpp \
#../src/sfxCore/airWindows/effects/DCVoltageProc.cpp \
#../src/sfxCore/airWindows/effects/DeBess.cpp \
#../src/sfxCore/airWindows/effects/DeBessProc.cpp \
#../src/sfxCore/airWindows/effects/Deckwrecka.cpp \
#../src/sfxCore/airWindows/effects/DeckwreckaProc.cpp \
#../src/sfxCore/airWindows/effects/DeEss.cpp \
#../src/sfxCore/airWindows/effects/DeEssProc.cpp \
#../src/sfxCore/airWindows/effects/DeHiss.cpp \
#../src/sfxCore/airWindows/effects/DeHissProc.cpp \
#../src/sfxCore/airWindows/effects/Density.cpp \
#../src/sfxCore/airWindows/effects/Density2.cpp \
#../src/sfxCore/airWindows/effects/Density2Proc.cpp \
#../src/sfxCore/airWindows/effects/DensityProc.cpp \
#../src/sfxCore/airWindows/effects/DeRez.cpp \
#../src/sfxCore/airWindows/effects/DeRez2.cpp \
#../src/sfxCore/airWindows/effects/DeRez2Proc.cpp \
#../src/sfxCore/airWindows/effects/DeRez3.cpp \
#../src/sfxCore/airWindows/effects/DeRez3Proc.cpp \
#../src/sfxCore/airWindows/effects/DeRezProc.cpp \
#../src/sfxCore/airWindows/effects/Desk.cpp \
#../src/sfxCore/airWindows/effects/Desk4.cpp \
#../src/sfxCore/airWindows/effects/Desk4Proc.cpp \
#../src/sfxCore/airWindows/effects/DeskProc.cpp \
#../src/sfxCore/airWindows/effects/DigitalBlack.cpp \
#../src/sfxCore/airWindows/effects/DigitalBlackProc.cpp \
#../src/sfxCore/airWindows/effects/Dirt.cpp \
#../src/sfxCore/airWindows/effects/DirtProc.cpp \
#../src/sfxCore/airWindows/effects/Discontinuity.cpp \
#../src/sfxCore/airWindows/effects/DiscontinuityProc.cpp \
#../src/sfxCore/airWindows/effects/Distance.cpp \
#../src/sfxCore/airWindows/effects/Distance2.cpp \
#../src/sfxCore/airWindows/effects/Distance2Proc.cpp \
#../src/sfxCore/airWindows/effects/Distance3.cpp \
#../src/sfxCore/airWindows/effects/Distance3Proc.cpp \
#../src/sfxCore/airWindows/effects/DistanceProc.cpp \
#../src/sfxCore/airWindows/effects/Distortion.cpp \
#../src/sfxCore/airWindows/effects/DistortionProc.cpp \
#../src/sfxCore/airWindows/effects/Ditherbox.cpp \
#../src/sfxCore/airWindows/effects/DitherboxProc.cpp \
#../src/sfxCore/airWindows/effects/DitherFloat.cpp \
#../src/sfxCore/airWindows/effects/DitherFloatProc.cpp \
#../src/sfxCore/airWindows/effects/DitherMeDiskers.cpp \
#../src/sfxCore/airWindows/effects/DitherMeDiskersProc.cpp \
#../src/sfxCore/airWindows/effects/DitherMeTimbers.cpp \
#../src/sfxCore/airWindows/effects/DitherMeTimbersProc.cpp \
#../src/sfxCore/airWindows/effects/Doublelay.cpp \
#../src/sfxCore/airWindows/effects/DoublelayProc.cpp \
#../src/sfxCore/airWindows/effects/DoublePaul.cpp \
#../src/sfxCore/airWindows/effects/DoublePaulProc.cpp \
#../src/sfxCore/airWindows/effects/Drive.cpp \
#../src/sfxCore/airWindows/effects/DriveProc.cpp \
#../src/sfxCore/airWindows/effects/DrumSlam.cpp \
#../src/sfxCore/airWindows/effects/DrumSlamProc.cpp \
#../src/sfxCore/airWindows/effects/DubCenter.cpp \
#../src/sfxCore/airWindows/effects/DubCenterProc.cpp \
#../src/sfxCore/airWindows/effects/Dubly.cpp \
#../src/sfxCore/airWindows/effects/DublyProc.cpp \
#../src/sfxCore/airWindows/effects/DubSub.cpp \
#../src/sfxCore/airWindows/effects/DubSubProc.cpp \
#../src/sfxCore/airWindows/effects/DustBunny.cpp \
#../src/sfxCore/airWindows/effects/DustBunnyProc.cpp \
#../src/sfxCore/airWindows/effects/Dynamics.cpp \
#../src/sfxCore/airWindows/effects/DynamicsProc.cpp \
#../src/sfxCore/airWindows/effects/Dyno.cpp \
#../src/sfxCore/airWindows/effects/DynoProc.cpp \
#../src/sfxCore/airWindows/effects/Edge.cpp \
#../src/sfxCore/airWindows/effects/EdgeProc.cpp \
#../src/sfxCore/airWindows/effects/EdIsDim.cpp \
#../src/sfxCore/airWindows/effects/EdIsDimProc.cpp \
#../src/sfxCore/airWindows/effects/Elation.cpp \
#../src/sfxCore/airWindows/effects/ElationProc.cpp \
#../src/sfxCore/airWindows/effects/ElectroHat.cpp \
#../src/sfxCore/airWindows/effects/ElectroHatProc.cpp \
#../src/sfxCore/airWindows/effects/Energy.cpp \
#../src/sfxCore/airWindows/effects/Energy2.cpp \
#../src/sfxCore/airWindows/effects/Energy2Proc.cpp \
#../src/sfxCore/airWindows/effects/EnergyProc.cpp \
#../src/sfxCore/airWindows/effects/Ensemble.cpp \
#../src/sfxCore/airWindows/effects/EnsembleProc.cpp \
#../src/sfxCore/airWindows/effects/EQ.cpp \
#../src/sfxCore/airWindows/effects/EQProc.cpp \
#../src/sfxCore/airWindows/effects/EveryConsole.cpp \
#../src/sfxCore/airWindows/effects/EveryConsoleProc.cpp \
#../src/sfxCore/airWindows/effects/EverySlew.cpp \
#../src/sfxCore/airWindows/effects/EverySlewProc.cpp \
#../src/sfxCore/airWindows/effects/EveryTrim.cpp \
#../src/sfxCore/airWindows/effects/EveryTrimProc.cpp \
#../src/sfxCore/airWindows/effects/Exciter.cpp \
#../src/sfxCore/airWindows/effects/ExciterProc.cpp \
#../src/sfxCore/airWindows/effects/Facet.cpp \
#../src/sfxCore/airWindows/effects/FacetProc.cpp \
#../src/sfxCore/airWindows/effects/FathomFive.cpp \
#../src/sfxCore/airWindows/effects/FathomFiveProc.cpp \
#../src/sfxCore/airWindows/effects/FinalClip.cpp \
#../src/sfxCore/airWindows/effects/FinalClipProc.cpp \
#../src/sfxCore/airWindows/effects/FireAmp.cpp \
#../src/sfxCore/airWindows/effects/FireAmpProc.cpp \
#../src/sfxCore/airWindows/effects/Flipity.cpp \
#../src/sfxCore/airWindows/effects/FlipityProc.cpp \
#../src/sfxCore/airWindows/effects/Floor.cpp \
#../src/sfxCore/airWindows/effects/FloorProc.cpp \
#../src/sfxCore/airWindows/effects/Flutter.cpp \
#../src/sfxCore/airWindows/effects/FlutterProc.cpp \
#../src/sfxCore/airWindows/effects/Focus.cpp \
#../src/sfxCore/airWindows/effects/FocusProc.cpp \
#../src/sfxCore/airWindows/effects/Fracture.cpp \
#../src/sfxCore/airWindows/effects/Fracture2.cpp \
#../src/sfxCore/airWindows/effects/Fracture2Proc.cpp \
#../src/sfxCore/airWindows/effects/FractureProc.cpp \
#../src/sfxCore/airWindows/effects/FromTape.cpp \
#../src/sfxCore/airWindows/effects/FromTapeProc.cpp \
#../src/sfxCore/airWindows/effects/Galactic.cpp \
#../src/sfxCore/airWindows/effects/Galactic2.cpp \
#../src/sfxCore/airWindows/effects/Galactic2Proc.cpp \
#../src/sfxCore/airWindows/effects/GalacticProc.cpp \
#../src/sfxCore/airWindows/effects/GalacticVibe.cpp \
#../src/sfxCore/airWindows/effects/GalacticVibeProc.cpp \
#../src/sfxCore/airWindows/effects/Gatelope.cpp \
#../src/sfxCore/airWindows/effects/GatelopeProc.cpp \
#../src/sfxCore/airWindows/effects/GlitchShifter.cpp \
#../src/sfxCore/airWindows/effects/GlitchShifterProc.cpp \
#../src/sfxCore/airWindows/effects/GoldenSlew.cpp \
#../src/sfxCore/airWindows/effects/GoldenSlewProc.cpp \
#../src/sfxCore/airWindows/effects/Golem.cpp \
#../src/sfxCore/airWindows/effects/GolemProc.cpp \
#../src/sfxCore/airWindows/effects/GrindAmp.cpp \
#../src/sfxCore/airWindows/effects/GrindAmpProc.cpp \
#../src/sfxCore/airWindows/effects/Gringer.cpp \
#../src/sfxCore/airWindows/effects/GringerProc.cpp \
#../src/sfxCore/airWindows/effects/GrooveWear.cpp \
#../src/sfxCore/airWindows/effects/GrooveWearProc.cpp \
#../src/sfxCore/airWindows/effects/GuitarConditioner.cpp \
#../src/sfxCore/airWindows/effects/GuitarConditionerProc.cpp \
#../src/sfxCore/airWindows/effects/HardVacuum.cpp \
#../src/sfxCore/airWindows/effects/HardVacuumProc.cpp \
#../src/sfxCore/airWindows/effects/Hermepass.cpp \
#../src/sfxCore/airWindows/effects/HermepassProc.cpp \
#../src/sfxCore/airWindows/effects/HermeTrim.cpp \
#../src/sfxCore/airWindows/effects/HermeTrimProc.cpp \
#../src/sfxCore/airWindows/effects/HighGlossDither.cpp \
#../src/sfxCore/airWindows/effects/HighGlossDitherProc.cpp \
#../src/sfxCore/airWindows/effects/HighImpact.cpp \
#../src/sfxCore/airWindows/effects/HighImpactProc.cpp \
#../src/sfxCore/airWindows/effects/Highpass.cpp \
#../src/sfxCore/airWindows/effects/Highpass2.cpp \
#../src/sfxCore/airWindows/effects/Highpass2Proc.cpp \
#../src/sfxCore/airWindows/effects/HighpassProc.cpp \
#../src/sfxCore/airWindows/effects/Holt.cpp \
#../src/sfxCore/airWindows/effects/Holt2.cpp \
#../src/sfxCore/airWindows/effects/Holt2Proc.cpp \
#../src/sfxCore/airWindows/effects/HoltProc.cpp \
#../src/sfxCore/airWindows/effects/Hombre.cpp \
#../src/sfxCore/airWindows/effects/HombreProc.cpp \
#../src/sfxCore/airWindows/effects/Huge.cpp \
#../src/sfxCore/airWindows/effects/HugeProc.cpp \
#../src/sfxCore/airWindows/effects/Hull.cpp \
#../src/sfxCore/airWindows/effects/Hull2.cpp \
#../src/sfxCore/airWindows/effects/Hull2Proc.cpp \
#../src/sfxCore/airWindows/effects/HullProc.cpp \
#../src/sfxCore/airWindows/effects/Hype.cpp \
#../src/sfxCore/airWindows/effects/HypeProc.cpp \
#../src/sfxCore/airWindows/effects/Hypersonic.cpp \
#../src/sfxCore/airWindows/effects/HypersonicProc.cpp \
#../src/sfxCore/airWindows/effects/HypersonX.cpp \
#../src/sfxCore/airWindows/effects/HypersonXProc.cpp \
#../src/sfxCore/airWindows/effects/Infinity.cpp \
#../src/sfxCore/airWindows/effects/Infinity2.cpp \
#../src/sfxCore/airWindows/effects/Infinity2Proc.cpp \
#../src/sfxCore/airWindows/effects/InfinityProc.cpp \
#../src/sfxCore/airWindows/effects/Inflamer.cpp \
#../src/sfxCore/airWindows/effects/InflamerProc.cpp \
#../src/sfxCore/airWindows/effects/Infrasonic.cpp \
#../src/sfxCore/airWindows/effects/InfrasonicProc.cpp \
#../src/sfxCore/airWindows/effects/Interstage.cpp \
#../src/sfxCore/airWindows/effects/InterstageProc.cpp \
#../src/sfxCore/airWindows/effects/IronOxide5.cpp \
#../src/sfxCore/airWindows/effects/IronOxide5Proc.cpp \
#../src/sfxCore/airWindows/effects/IronOxideClassic.cpp \
#../src/sfxCore/airWindows/effects/IronOxideClassic2.cpp \
#../src/sfxCore/airWindows/effects/IronOxideClassic2Proc.cpp \
#../src/sfxCore/airWindows/effects/IronOxideClassicProc.cpp \
#../src/sfxCore/airWindows/effects/Isolator.cpp \
#../src/sfxCore/airWindows/effects/Isolator2.cpp \
#../src/sfxCore/airWindows/effects/Isolator2Proc.cpp \
#../src/sfxCore/airWindows/effects/IsolatorProc.cpp \
#../src/sfxCore/airWindows/effects/Kalman.cpp \
#../src/sfxCore/airWindows/effects/KalmanProc.cpp \
#../src/sfxCore/airWindows/effects/kCathedral.cpp \
#../src/sfxCore/airWindows/effects/kCathedral2.cpp \
#../src/sfxCore/airWindows/effects/kCathedral2Proc.cpp \
#../src/sfxCore/airWindows/effects/kCathedral3.cpp \
#../src/sfxCore/airWindows/effects/kCathedral3Proc.cpp \
#../src/sfxCore/airWindows/effects/kCathedralProc.cpp \
#../src/sfxCore/airWindows/effects/kChamberAR.cpp \
#../src/sfxCore/airWindows/effects/kChamberARProc.cpp \
#../src/sfxCore/airWindows/effects/kGuitarHall.cpp \
#../src/sfxCore/airWindows/effects/kGuitarHallProc.cpp \
#../src/sfxCore/airWindows/effects/kPlate140.cpp \
#../src/sfxCore/airWindows/effects/kPlate140Proc.cpp \
#../src/sfxCore/airWindows/effects/kPlate240.cpp \
#../src/sfxCore/airWindows/effects/kPlate240Proc.cpp \
#../src/sfxCore/airWindows/effects/kPlateA.cpp \
#../src/sfxCore/airWindows/effects/kPlateAProc.cpp \
#../src/sfxCore/airWindows/effects/kPlateB.cpp \
#../src/sfxCore/airWindows/effects/kPlateBProc.cpp \
#../src/sfxCore/airWindows/effects/kPlateC.cpp \
#../src/sfxCore/airWindows/effects/kPlateCProc.cpp \
#../src/sfxCore/airWindows/effects/kPlateD.cpp \
#../src/sfxCore/airWindows/effects/kPlateDProc.cpp \
#../src/sfxCore/airWindows/effects/LeadAmp.cpp \
#../src/sfxCore/airWindows/effects/LeadAmpProc.cpp \
#../src/sfxCore/airWindows/effects/LeftoMono.cpp \
#../src/sfxCore/airWindows/effects/LeftoMonoProc.cpp \
#../src/sfxCore/airWindows/effects/LilAmp.cpp \
#../src/sfxCore/airWindows/effects/LilAmpProc.cpp \
#../src/sfxCore/airWindows/effects/Logical4.cpp \
#../src/sfxCore/airWindows/effects/Logical4Proc.cpp \
#../src/sfxCore/airWindows/effects/Loud.cpp \
#../src/sfxCore/airWindows/effects/LoudProc.cpp \
#../src/sfxCore/airWindows/effects/Lowpass.cpp \
#../src/sfxCore/airWindows/effects/Lowpass2.cpp \
#../src/sfxCore/airWindows/effects/Lowpass2Proc.cpp \
#../src/sfxCore/airWindows/effects/LowpassProc.cpp \
#../src/sfxCore/airWindows/effects/LRFlipTimer.cpp \
#../src/sfxCore/airWindows/effects/LRFlipTimerProc.cpp \
#../src/sfxCore/airWindows/effects/Luxor.cpp \
#../src/sfxCore/airWindows/effects/LuxorProc.cpp \
#../src/sfxCore/airWindows/effects/MackEQ.cpp \
#../src/sfxCore/airWindows/effects/MackEQProc.cpp \
#../src/sfxCore/airWindows/effects/Mackity.cpp \
#../src/sfxCore/airWindows/effects/MackityProc.cpp \
#../src/sfxCore/airWindows/effects/MatrixVerb.cpp \
#../src/sfxCore/airWindows/effects/MatrixVerbProc.cpp \
#../src/sfxCore/airWindows/effects/Melt.cpp \
#../src/sfxCore/airWindows/effects/MeltProc.cpp \
#../src/sfxCore/airWindows/effects/MidAmp.cpp \
#../src/sfxCore/airWindows/effects/MidAmpProc.cpp \
#../src/sfxCore/airWindows/effects/MidSide.cpp \
#../src/sfxCore/airWindows/effects/MidSideProc.cpp \
#../src/sfxCore/airWindows/effects/Mojo.cpp \
#../src/sfxCore/airWindows/effects/MojoProc.cpp \
#../src/sfxCore/airWindows/effects/Monitoring.cpp \
#../src/sfxCore/airWindows/effects/Monitoring2.cpp \
#../src/sfxCore/airWindows/effects/Monitoring2Proc.cpp \
#../src/sfxCore/airWindows/effects/Monitoring3.cpp \
#../src/sfxCore/airWindows/effects/Monitoring3Proc.cpp \
#../src/sfxCore/airWindows/effects/MonitoringProc.cpp \
#../src/sfxCore/airWindows/effects/MoNoam.cpp \
#../src/sfxCore/airWindows/effects/MoNoamProc.cpp \
#../src/sfxCore/airWindows/effects/MSFlipTimer.cpp \
#../src/sfxCore/airWindows/effects/MSFlipTimerProc.cpp \
#../src/sfxCore/airWindows/effects/MultiBandDistortion.cpp \
#../src/sfxCore/airWindows/effects/MultiBandDistortionProc.cpp \
#../src/sfxCore/airWindows/effects/MV.cpp \
#../src/sfxCore/airWindows/effects/MV2.cpp \
#../src/sfxCore/airWindows/effects/MV2Proc.cpp \
#../src/sfxCore/airWindows/effects/MVProc.cpp \
#../src/sfxCore/airWindows/effects/NaturalizeDither.cpp \
#../src/sfxCore/airWindows/effects/NaturalizeDitherProc.cpp \
#../src/sfxCore/airWindows/effects/NCSeventeen.cpp \
#../src/sfxCore/airWindows/effects/NCSeventeenProc.cpp \
#../src/sfxCore/airWindows/effects/Neverland.cpp \
#../src/sfxCore/airWindows/effects/NeverlandProc.cpp \
#../src/sfxCore/airWindows/effects/Nikola.cpp \
#../src/sfxCore/airWindows/effects/NikolaProc.cpp \
#../src/sfxCore/airWindows/effects/NodeDither.cpp \
#../src/sfxCore/airWindows/effects/NodeDitherProc.cpp \
#../src/sfxCore/airWindows/effects/Noise.cpp \
#../src/sfxCore/airWindows/effects/NoiseProc.cpp \
#../src/sfxCore/airWindows/effects/NonlinearSpace.cpp \
#../src/sfxCore/airWindows/effects/NonlinearSpaceProc.cpp \
#../src/sfxCore/airWindows/effects/NotJustAnotherCD.cpp \
#../src/sfxCore/airWindows/effects/NotJustAnotherCDProc.cpp \
#../src/sfxCore/airWindows/effects/NotJustAnotherDither.cpp \
#../src/sfxCore/airWindows/effects/NotJustAnotherDitherProc.cpp \
#../src/sfxCore/airWindows/effects/OneCornerClip.cpp \
#../src/sfxCore/airWindows/effects/OneCornerClipProc.cpp \
#../src/sfxCore/airWindows/effects/OrbitKick.cpp \
#../src/sfxCore/airWindows/effects/OrbitKickProc.cpp \
#../src/sfxCore/airWindows/effects/Overheads.cpp \
#../src/sfxCore/airWindows/effects/OverheadsProc.cpp \
#../src/sfxCore/airWindows/effects/Pafnuty.cpp \
#../src/sfxCore/airWindows/effects/Pafnuty2.cpp \
#../src/sfxCore/airWindows/effects/Pafnuty2Proc.cpp \
#../src/sfxCore/airWindows/effects/PafnutyProc.cpp \
#../src/sfxCore/airWindows/effects/Parametric.cpp \
#../src/sfxCore/airWindows/effects/ParametricProc.cpp \
#../src/sfxCore/airWindows/effects/PaulDither.cpp \
#../src/sfxCore/airWindows/effects/PaulDitherProc.cpp \
#../src/sfxCore/airWindows/effects/PaulWide.cpp \
#../src/sfxCore/airWindows/effects/PaulWideProc.cpp \
#../src/sfxCore/airWindows/effects/PDBuss.cpp \
#../src/sfxCore/airWindows/effects/PDBussProc.cpp \
#../src/sfxCore/airWindows/effects/PDChannel.cpp \
#../src/sfxCore/airWindows/effects/PDChannelProc.cpp \
#../src/sfxCore/airWindows/effects/PeaksOnly.cpp \
#../src/sfxCore/airWindows/effects/PeaksOnlyProc.cpp \
#../src/sfxCore/airWindows/effects/Pear.cpp \
#../src/sfxCore/airWindows/effects/Pear2.cpp \
#../src/sfxCore/airWindows/effects/Pear2Proc.cpp \
#../src/sfxCore/airWindows/effects/PearProc.cpp \
#../src/sfxCore/airWindows/effects/PhaseNudge.cpp \
#../src/sfxCore/airWindows/effects/PhaseNudgeProc.cpp \
#../src/sfxCore/airWindows/effects/PitchDelay.cpp \
#../src/sfxCore/airWindows/effects/PitchDelayProc.cpp \
#../src/sfxCore/airWindows/effects/PitchNasty.cpp \
#../src/sfxCore/airWindows/effects/PitchNastyProc.cpp \
#../src/sfxCore/airWindows/effects/PlatinumSlew.cpp \
#../src/sfxCore/airWindows/effects/PlatinumSlewProc.cpp \
#../src/sfxCore/airWindows/effects/PocketVerbs.cpp \
#../src/sfxCore/airWindows/effects/PocketVerbsProc.cpp \
#../src/sfxCore/airWindows/effects/Pockey.cpp \
#../src/sfxCore/airWindows/effects/Pockey2.cpp \
#../src/sfxCore/airWindows/effects/Pockey2Proc.cpp \
#../src/sfxCore/airWindows/effects/PockeyProc.cpp \
#../src/sfxCore/airWindows/effects/Podcast.cpp \
#../src/sfxCore/airWindows/effects/PodcastDeluxe.cpp \
#../src/sfxCore/airWindows/effects/PodcastDeluxeProc.cpp \
#../src/sfxCore/airWindows/effects/PodcastProc.cpp \
#../src/sfxCore/airWindows/effects/Point.cpp \
#../src/sfxCore/airWindows/effects/PointProc.cpp \
#../src/sfxCore/airWindows/effects/Pop.cpp \
#../src/sfxCore/airWindows/effects/Pop2.cpp \
#../src/sfxCore/airWindows/effects/Pop2Proc.cpp \
#../src/sfxCore/airWindows/effects/Pop3.cpp \
#../src/sfxCore/airWindows/effects/Pop3Proc.cpp \
#../src/sfxCore/airWindows/effects/PopProc.cpp \
#../src/sfxCore/airWindows/effects/PowerSag.cpp \
#../src/sfxCore/airWindows/effects/PowerSag2.cpp \
#../src/sfxCore/airWindows/effects/PowerSag2Proc.cpp \
#../src/sfxCore/airWindows/effects/PowerSagProc.cpp \
#../src/sfxCore/airWindows/effects/Precious.cpp \
#../src/sfxCore/airWindows/effects/PreciousProc.cpp \
#../src/sfxCore/airWindows/effects/Preponderant.cpp \
#../src/sfxCore/airWindows/effects/PreponderantProc.cpp \
#../src/sfxCore/airWindows/effects/Pressure4.cpp \
#../src/sfxCore/airWindows/effects/Pressure4Proc.cpp \
#../src/sfxCore/airWindows/effects/Pressure5.cpp \
#../src/sfxCore/airWindows/effects/Pressure5Proc.cpp \
#../src/sfxCore/airWindows/effects/PurestAir.cpp \
#../src/sfxCore/airWindows/effects/PurestAirProc.cpp \
#../src/sfxCore/airWindows/effects/PurestConsole2Buss.cpp \
#../src/sfxCore/airWindows/effects/PurestConsole2BussProc.cpp \
#../src/sfxCore/airWindows/effects/PurestConsole2Channel.cpp \
#../src/sfxCore/airWindows/effects/PurestConsole2ChannelProc.cpp \
#../src/sfxCore/airWindows/effects/PurestConsole3Buss.cpp \
#../src/sfxCore/airWindows/effects/PurestConsole3BussProc.cpp \
#../src/sfxCore/airWindows/effects/PurestConsole3Channel.cpp \
#../src/sfxCore/airWindows/effects/PurestConsole3ChannelProc.cpp \
#../src/sfxCore/airWindows/effects/PurestConsoleBuss.cpp \
#../src/sfxCore/airWindows/effects/PurestConsoleBussProc.cpp \
#../src/sfxCore/airWindows/effects/PurestConsoleChannel.cpp \
#../src/sfxCore/airWindows/effects/PurestConsoleChannelProc.cpp \
#../src/sfxCore/airWindows/effects/PurestDrive.cpp \
#../src/sfxCore/airWindows/effects/PurestDriveProc.cpp \
#../src/sfxCore/airWindows/effects/PurestEcho.cpp \
#../src/sfxCore/airWindows/effects/PurestEchoProc.cpp \
#../src/sfxCore/airWindows/effects/PurestFade.cpp \
#../src/sfxCore/airWindows/effects/PurestFadeProc.cpp \
#../src/sfxCore/airWindows/effects/PurestGain.cpp \
#../src/sfxCore/airWindows/effects/PurestGainProc.cpp \
#../src/sfxCore/airWindows/effects/PurestSquish.cpp \
#../src/sfxCore/airWindows/effects/PurestSquishProc.cpp \
#../src/sfxCore/airWindows/effects/PurestWarm.cpp \
#../src/sfxCore/airWindows/effects/PurestWarm2.cpp \
#../src/sfxCore/airWindows/effects/PurestWarm2Proc.cpp \
#../src/sfxCore/airWindows/effects/PurestWarmProc.cpp \
#../src/sfxCore/airWindows/effects/Pyewacket.cpp \
#../src/sfxCore/airWindows/effects/PyewacketProc.cpp \
#../src/sfxCore/airWindows/effects/RawGlitters.cpp \
#../src/sfxCore/airWindows/effects/RawGlittersProc.cpp \
#../src/sfxCore/airWindows/effects/RawTimbers.cpp \
#../src/sfxCore/airWindows/effects/RawTimbersProc.cpp \
#../src/sfxCore/airWindows/effects/Recurve.cpp \
#../src/sfxCore/airWindows/effects/RecurveProc.cpp \
#../src/sfxCore/airWindows/effects/Remap.cpp \
#../src/sfxCore/airWindows/effects/RemapProc.cpp \
#../src/sfxCore/airWindows/effects/ResEQ.cpp \
#../src/sfxCore/airWindows/effects/ResEQ2.cpp \
#../src/sfxCore/airWindows/effects/ResEQ2Proc.cpp \
#../src/sfxCore/airWindows/effects/ResEQProc.cpp \
#../src/sfxCore/airWindows/effects/Reverb.cpp \
#../src/sfxCore/airWindows/effects/ReverbProc.cpp \
#../src/sfxCore/airWindows/effects/Righteous4.cpp \
#../src/sfxCore/airWindows/effects/Righteous4Proc.cpp \
#../src/sfxCore/airWindows/effects/RightoMono.cpp \
#../src/sfxCore/airWindows/effects/RightoMonoProc.cpp \
#../src/sfxCore/airWindows/effects/SampleDelay.cpp \
#../src/sfxCore/airWindows/effects/SampleDelayProc.cpp \
#../src/sfxCore/airWindows/effects/Shape.cpp \
#../src/sfxCore/airWindows/effects/ShapeProc.cpp \
#../src/sfxCore/airWindows/effects/ShortBuss.cpp \
#../src/sfxCore/airWindows/effects/ShortBussProc.cpp \
#../src/sfxCore/airWindows/effects/SideDull.cpp \
#../src/sfxCore/airWindows/effects/SideDullProc.cpp \
#../src/sfxCore/airWindows/effects/Sidepass.cpp \
#../src/sfxCore/airWindows/effects/SidepassProc.cpp \
#../src/sfxCore/airWindows/effects/Silhouette.cpp \
#../src/sfxCore/airWindows/effects/SilhouetteProc.cpp \
#../src/sfxCore/airWindows/effects/Sinew.cpp \
#../src/sfxCore/airWindows/effects/SinewProc.cpp \
#../src/sfxCore/airWindows/effects/SingleEndedTriode.cpp \
#../src/sfxCore/airWindows/effects/SingleEndedTriodeProc.cpp \
#../src/sfxCore/airWindows/effects/Slew.cpp \
#../src/sfxCore/airWindows/effects/Slew2.cpp \
#../src/sfxCore/airWindows/effects/Slew2Proc.cpp \
#../src/sfxCore/airWindows/effects/Slew3.cpp \
#../src/sfxCore/airWindows/effects/Slew3Proc.cpp \
#../src/sfxCore/airWindows/effects/SlewOnly.cpp \
#../src/sfxCore/airWindows/effects/SlewOnlyProc.cpp \
#../src/sfxCore/airWindows/effects/SlewProc.cpp \
#../src/sfxCore/airWindows/effects/SlewSonic.cpp \
#../src/sfxCore/airWindows/effects/SlewSonicProc.cpp \
#../src/sfxCore/airWindows/effects/Smooth.cpp \
#../src/sfxCore/airWindows/effects/SmoothProc.cpp \
#../src/sfxCore/airWindows/effects/SoftGate.cpp \
#../src/sfxCore/airWindows/effects/SoftGateProc.cpp \
#../src/sfxCore/airWindows/effects/SpatializeDither.cpp \
#../src/sfxCore/airWindows/effects/SpatializeDitherProc.cpp \
#../src/sfxCore/airWindows/effects/Spiral.cpp \
#../src/sfxCore/airWindows/effects/Spiral2.cpp \
#../src/sfxCore/airWindows/effects/Spiral2Proc.cpp \
#../src/sfxCore/airWindows/effects/SpiralProc.cpp \
#../src/sfxCore/airWindows/effects/Srsly.cpp \
#../src/sfxCore/airWindows/effects/Srsly2.cpp \
#../src/sfxCore/airWindows/effects/Srsly2Proc.cpp \
#../src/sfxCore/airWindows/effects/Srsly3.cpp \
#../src/sfxCore/airWindows/effects/Srsly3Proc.cpp \
#../src/sfxCore/airWindows/effects/SrslyProc.cpp \
#../src/sfxCore/airWindows/effects/StarChild.cpp \
#../src/sfxCore/airWindows/effects/StarChild2.cpp \
#../src/sfxCore/airWindows/effects/StarChild2Proc.cpp \
#../src/sfxCore/airWindows/effects/StarChildProc.cpp \
#../src/sfxCore/airWindows/effects/StereoChorus.cpp \
#../src/sfxCore/airWindows/effects/StereoChorusProc.cpp \
#../src/sfxCore/airWindows/effects/StereoDoubler.cpp \
#../src/sfxCore/airWindows/effects/StereoDoublerProc.cpp \
#../src/sfxCore/airWindows/effects/StereoEnsemble.cpp \
#../src/sfxCore/airWindows/effects/StereoEnsembleProc.cpp \
#../src/sfxCore/airWindows/effects/StereoFX.cpp \
#../src/sfxCore/airWindows/effects/StereoFXProc.cpp \
#../src/sfxCore/airWindows/effects/Stonefire.cpp \
#../src/sfxCore/airWindows/effects/StoneFireComp.cpp \
#../src/sfxCore/airWindows/effects/StoneFireCompProc.cpp \
#../src/sfxCore/airWindows/effects/StonefireProc.cpp \
#../src/sfxCore/airWindows/effects/StudioTan.cpp \
#../src/sfxCore/airWindows/effects/StudioTanProc.cpp \
#../src/sfxCore/airWindows/effects/SubsOnly.cpp \
#../src/sfxCore/airWindows/effects/SubsOnlyProc.cpp \
#../src/sfxCore/airWindows/effects/SubTight.cpp \
#../src/sfxCore/airWindows/effects/SubTightProc.cpp \
#../src/sfxCore/airWindows/effects/Surge.cpp \
#../src/sfxCore/airWindows/effects/SurgeProc.cpp \
#../src/sfxCore/airWindows/effects/SurgeTide.cpp \
#../src/sfxCore/airWindows/effects/SurgeTideProc.cpp \
#../src/sfxCore/airWindows/effects/Sweeten.cpp \
#../src/sfxCore/airWindows/effects/SweetenProc.cpp \
#../src/sfxCore/airWindows/effects/Swell.cpp \
#../src/sfxCore/airWindows/effects/SwellProc.cpp \
#../src/sfxCore/airWindows/effects/Tape.cpp \
#../src/sfxCore/airWindows/effects/TapeDelay.cpp \
#../src/sfxCore/airWindows/effects/TapeDelay2.cpp \
#../src/sfxCore/airWindows/effects/TapeDelay2Proc.cpp \
#../src/sfxCore/airWindows/effects/TapeDelayProc.cpp \
#../src/sfxCore/airWindows/effects/TapeDither.cpp \
#../src/sfxCore/airWindows/effects/TapeDitherProc.cpp \
#../src/sfxCore/airWindows/effects/TapeDust.cpp \
#../src/sfxCore/airWindows/effects/TapeDustProc.cpp \
#../src/sfxCore/airWindows/effects/TapeFat.cpp \
#../src/sfxCore/airWindows/effects/TapeFatProc.cpp \
#../src/sfxCore/airWindows/effects/TapeProc.cpp \
#../src/sfxCore/airWindows/effects/Texturize.cpp \
#../src/sfxCore/airWindows/effects/TexturizeMS.cpp \
#../src/sfxCore/airWindows/effects/TexturizeMSProc.cpp \
#../src/sfxCore/airWindows/effects/TexturizeProc.cpp \
#../src/sfxCore/airWindows/effects/Thunder.cpp \
#../src/sfxCore/airWindows/effects/ThunderProc.cpp \
#../src/sfxCore/airWindows/effects/ToneSlant.cpp \
#../src/sfxCore/airWindows/effects/ToneSlantProc.cpp \
#../src/sfxCore/airWindows/effects/ToTape5.cpp \
#../src/sfxCore/airWindows/effects/ToTape5Proc.cpp \
#../src/sfxCore/airWindows/effects/ToTape6.cpp \
#../src/sfxCore/airWindows/effects/ToTape6Proc.cpp \
#../src/sfxCore/airWindows/effects/ToVinyl4.cpp \
#../src/sfxCore/airWindows/effects/ToVinyl4Proc.cpp \
#../src/sfxCore/airWindows/effects/TPDFDither.cpp \
#../src/sfxCore/airWindows/effects/TPDFDitherProc.cpp \
#../src/sfxCore/airWindows/effects/TPDFWide.cpp \
#../src/sfxCore/airWindows/effects/TPDFWideProc.cpp \
#../src/sfxCore/airWindows/effects/TransDesk.cpp \
#../src/sfxCore/airWindows/effects/TransDeskProc.cpp \
#../src/sfxCore/airWindows/effects/Tremolo.cpp \
#../src/sfxCore/airWindows/effects/TremoloProc.cpp \
#../src/sfxCore/airWindows/effects/TremoSquare.cpp \
#../src/sfxCore/airWindows/effects/TremoSquareProc.cpp \
#../src/sfxCore/airWindows/effects/Trianglizer.cpp \
#../src/sfxCore/airWindows/effects/TrianglizerProc.cpp \
#../src/sfxCore/airWindows/effects/TripleSpread.cpp \
#../src/sfxCore/airWindows/effects/TripleSpreadProc.cpp \
#../src/sfxCore/airWindows/effects/Tube.cpp \
#../src/sfxCore/airWindows/effects/Tube2.cpp \
#../src/sfxCore/airWindows/effects/Tube2Proc.cpp \
#../src/sfxCore/airWindows/effects/TubeDesk.cpp \
#../src/sfxCore/airWindows/effects/TubeDeskProc.cpp \
#../src/sfxCore/airWindows/effects/TubeProc.cpp \
#../src/sfxCore/airWindows/effects/uLawDecode.cpp \
#../src/sfxCore/airWindows/effects/uLawDecodeProc.cpp \
#../src/sfxCore/airWindows/effects/uLawEncode.cpp \
#../src/sfxCore/airWindows/effects/uLawEncodeProc.cpp \
#../src/sfxCore/airWindows/effects/Ultrasonic.cpp \
#../src/sfxCore/airWindows/effects/UltrasonicLite.cpp \
#../src/sfxCore/airWindows/effects/UltrasonicLiteProc.cpp \
#../src/sfxCore/airWindows/effects/UltrasonicMed.cpp \
#../src/sfxCore/airWindows/effects/UltrasonicMedProc.cpp \
#../src/sfxCore/airWindows/effects/UltrasonicProc.cpp \
#../src/sfxCore/airWindows/effects/UltrasonX.cpp \
#../src/sfxCore/airWindows/effects/UltrasonXProc.cpp \
#../src/sfxCore/airWindows/effects/UnBox.cpp \
#../src/sfxCore/airWindows/effects/UnBoxProc.cpp \
#../src/sfxCore/airWindows/effects/VariMu.cpp \
#../src/sfxCore/airWindows/effects/VariMuProc.cpp \
#../src/sfxCore/airWindows/effects/Verbity.cpp \
#../src/sfxCore/airWindows/effects/Verbity2.cpp \
#../src/sfxCore/airWindows/effects/Verbity2Proc.cpp \
#../src/sfxCore/airWindows/effects/VerbityProc.cpp \
#../src/sfxCore/airWindows/effects/Vibrato.cpp \
#../src/sfxCore/airWindows/effects/VibratoProc.cpp \
#../src/sfxCore/airWindows/effects/VinylDither.cpp \
#../src/sfxCore/airWindows/effects/VinylDitherProc.cpp \
#../src/sfxCore/airWindows/effects/VoiceOfTheStarship.cpp \
#../src/sfxCore/airWindows/effects/VoiceOfTheStarshipProc.cpp \
#../src/sfxCore/airWindows/effects/VoiceTrick.cpp \
#../src/sfxCore/airWindows/effects/VoiceTrickProc.cpp \
#../src/sfxCore/airWindows/effects/Weight.cpp \
#../src/sfxCore/airWindows/effects/WeightProc.cpp \
#../src/sfxCore/airWindows/effects/Wider.cpp \
#../src/sfxCore/airWindows/effects/WiderProc.cpp \
#../src/sfxCore/airWindows/effects/Wolfbot.cpp \
#../src/sfxCore/airWindows/effects/WolfbotProc.cpp \
#../src/sfxCore/airWindows/effects/XBandpass.cpp \
#../src/sfxCore/airWindows/effects/XBandpassProc.cpp \
#../src/sfxCore/airWindows/effects/XHighpass.cpp \
#../src/sfxCore/airWindows/effects/XHighpassProc.cpp \
#../src/sfxCore/airWindows/effects/XLowpass.cpp \
#../src/sfxCore/airWindows/effects/XLowpassProc.cpp \
#../src/sfxCore/airWindows/effects/XNotch.cpp \
#../src/sfxCore/airWindows/effects/XNotchProc.cpp \
#../src/sfxCore/airWindows/effects/XRegion.cpp \
#../src/sfxCore/airWindows/effects/XRegionProc.cpp \
#../src/sfxCore/airWindows/effects/YBandpass.cpp \
#../src/sfxCore/airWindows/effects/YBandpassProc.cpp \
#../src/sfxCore/airWindows/effects/YHighpass.cpp \
#../src/sfxCore/airWindows/effects/YHighpassProc.cpp \
#../src/sfxCore/airWindows/effects/YLowpass.cpp \
#../src/sfxCore/airWindows/effects/YLowpassProc.cpp \
#../src/sfxCore/airWindows/effects/YNotBandpass.cpp \
#../src/sfxCore/airWindows/effects/YNotBandpassProc.cpp \
#../src/sfxCore/airWindows/effects/YNotch.cpp \
#../src/sfxCore/airWindows/effects/YNotchProc.cpp \
#../src/sfxCore/airWindows/effects/YNotHighpass.cpp \
#../src/sfxCore/airWindows/effects/YNotHighpassProc.cpp \
#../src/sfxCore/airWindows/effects/YNotLowpass.cpp \
#../src/sfxCore/airWindows/effects/YNotLowpassProc.cpp \
#../src/sfxCore/airWindows/effects/YNotNotch.cpp \
#../src/sfxCore/airWindows/effects/YNotNotchProc.cpp \
#../src/sfxCore/airWindows/effects/ZBandpass.cpp \
#../src/sfxCore/airWindows/effects/ZBandpass2.cpp \
#../src/sfxCore/airWindows/effects/ZBandpass2Proc.cpp \
#../src/sfxCore/airWindows/effects/ZBandpassProc.cpp \
#../src/sfxCore/airWindows/effects/ZHighpass.cpp \
#../src/sfxCore/airWindows/effects/ZHighpass2.cpp \
#../src/sfxCore/airWindows/effects/ZHighpass2Proc.cpp \
#../src/sfxCore/airWindows/effects/ZHighpassProc.cpp \
#../src/sfxCore/airWindows/effects/ZLowpass.cpp \
#../src/sfxCore/airWindows/effects/ZLowpass2.cpp \
#../src/sfxCore/airWindows/effects/ZLowpass2Proc.cpp \
#../src/sfxCore/airWindows/effects/ZLowpassProc.cpp \
#../src/sfxCore/airWindows/effects/ZNotch.cpp \
#../src/sfxCore/airWindows/effects/ZNotch2.cpp \
#../src/sfxCore/airWindows/effects/ZNotch2Proc.cpp \
#../src/sfxCore/airWindows/effects/ZNotchProc.cpp \
#../src/sfxCore/airWindows/effects/ZOutputStage.cpp \
#../src/sfxCore/airWindows/effects/ZOutputStageProc.cpp \
#../src/sfxCore/airWindows/effects/ZRegion.cpp \
#../src/sfxCore/airWindows/effects/ZRegion2.cpp \
#../src/sfxCore/airWindows/effects/ZRegion2Proc.cpp \
#../src/sfxCore/airWindows/effects/ZRegionProc.cpp \
../src/sfxCore/neuralAmpModeler/dsp/dsp1.cpp \
../src/sfxCore/neuralAmpModeler/dsp/ImpulseResponse.cpp \
../src/sfxCore/neuralAmpModeler/dsp/NoiseGate.cpp \
../src/sfxCore/neuralAmpModeler/dsp/RecursiveLinearFilter.cpp \
../src/sfxCore/neuralAmpModeler/dsp/wav.cpp \
../src/sfxCore/neuralAmpModeler/nam/activations.cpp \
../src/sfxCore/neuralAmpModeler/nam/convnet.cpp \
../src/sfxCore/neuralAmpModeler/nam/dsp.cpp \
../src/sfxCore/neuralAmpModeler/nam/get_dsp.cpp \
../src/sfxCore/neuralAmpModeler/nam/lstm.cpp \
../src/sfxCore/neuralAmpModeler/nam/util.cpp \
../src/sfxCore/neuralAmpModeler/nam/wavenet.cpp \
../src/sfxCore/neuralAmpModeler/NeuralAmpModeler.cpp \
../src/sfxCore/neuralAmpModeler/sfxCoreNeuralAmpModeler.cpp \
../src/sfxCore/rakarrack/common/AnalogFilter.cpp \
../src/sfxCore/rakarrack/common/Compressor.cpp \
../src/sfxCore/rakarrack/common/EffectLFO.cpp \
../src/sfxCore/rakarrack/common/Filter.cpp \
../src/sfxCore/rakarrack/common/FilterParams.cpp \
../src/sfxCore/rakarrack/common/FormantFilter.cpp \
../src/sfxCore/rakarrack/common/HarmonicEnhancer.cpp \
../src/sfxCore/rakarrack/common/Metronome.cpp \
../src/sfxCore/rakarrack/common/RBFilter.cpp \
../src/sfxCore/rakarrack/common/Resample.cpp \
../src/sfxCore/rakarrack/common/SmbPitchShift.cpp \
../src/sfxCore/rakarrack/common/SVFilter.cpp \
../src/sfxCore/rakarrack/common/Waveshaper.cpp \
../src/sfxCore/rakarrack/common/AnalogFilter.cpp \
../src/sfxCore/rakarrack/common/Compressor.cpp \
../src/sfxCore/rakarrack/common/EffectLFO.cpp \
../src/sfxCore/rakarrack/common/Filter.cpp \
../src/sfxCore/rakarrack/common/FilterParams.cpp \
../src/sfxCore/rakarrack/common/FormantFilter.cpp \
../src/sfxCore/rakarrack/common/HarmonicEnhancer.cpp \
../src/sfxCore/rakarrack/common/Metronome.cpp \
../src/sfxCore/rakarrack/common/RBFilter.cpp \
../src/sfxCore/rakarrack/common/Resample.cpp \
../src/sfxCore/rakarrack/common/SmbPitchShift.cpp \
../src/sfxCore/rakarrack/common/SVFilter.cpp \
../src/sfxCore/rakarrack/common/Waveshaper.cpp \
../src/sfxCore/rakarrack/effects/Alienwah.cpp \
../src/sfxCore/rakarrack/effects/AnalogPhaser.cpp \
../src/sfxCore/rakarrack/effects/Arpie.cpp \
../src/sfxCore/rakarrack/effects/Chorus_.cpp \
../src/sfxCore/rakarrack/effects/CoilCrafter.cpp \
../src/sfxCore/rakarrack/effects/CompBand.cpp \
../src/sfxCore/rakarrack/effects/Convolotron.cpp \
../src/sfxCore/rakarrack/effects/Derelict.cpp \
../src/sfxCore/rakarrack/effects/DistBand.cpp \
../src/sfxCore/rakarrack/effects/Distorsion_.cpp \
../src/sfxCore/rakarrack/effects/DualFlange.cpp \
../src/sfxCore/rakarrack/effects/DynamicFilter.cpp \
../src/sfxCore/rakarrack/effects/Echo.cpp \
../src/sfxCore/rakarrack/effects/Echotron.cpp \
../src/sfxCore/rakarrack/effects/Echoverse.cpp \
../src/sfxCore/rakarrack/effects/EQ_.cpp \
../src/sfxCore/rakarrack/effects/Exciter_.cpp \
../src/sfxCore/rakarrack/effects/Expander.cpp \
../src/sfxCore/rakarrack/effects/Harmonizer.cpp \
../src/sfxCore/rakarrack/effects/MusicalDelay.cpp \
../src/sfxCore/rakarrack/effects/MuTroMojo.cpp \
../src/sfxCore/rakarrack/effects/NoiseGate_.cpp \
../src/sfxCore/rakarrack/effects/OpticalTrem.cpp \
../src/sfxCore/rakarrack/effects/Pan_.cpp \
../src/sfxCore/rakarrack/effects/Phaser.cpp \
../src/sfxCore/rakarrack/effects/Reverb_.cpp \
../src/sfxCore/rakarrack/effects/Reverbtron.cpp \
../src/sfxCore/rakarrack/effects/Ring.cpp \
../src/sfxCore/rakarrack/effects/Sequence.cpp \
../src/sfxCore/rakarrack/effects/ShelfBoost.cpp \
../src/sfxCore/rakarrack/effects/Shifter.cpp \
../src/sfxCore/rakarrack/effects/Shuffle.cpp \
../src/sfxCore/rakarrack/effects/StereoHarm.cpp \
../src/sfxCore/rakarrack/effects/StompBox.cpp \
../src/sfxCore/rakarrack/effects/Sustainer.cpp \
../src/sfxCore/rakarrack/effects/Synthfilter.cpp \
../src/sfxCore/rakarrack/effects/Valve.cpp \
../src/sfxCore/rakarrack/effects/VaryBand.cpp \
../src/sfxCore/rakarrack/effects/Vibe.cpp \
../src/sfxCore/rakarrack/effects/Vocoder.cpp

LOCAL_LDLIBS := -landroid -lGLESv3 -lEGL -laaudio
LOCAL_STATIC_LIBRARIES := android_native_app_glue
LOCAL_SHARED_LIBRARIES := openxr_loader
include $(BUILD_SHARED_LIBRARY)

$(call import-module, android/native_app_glue)
