// SPDX-License-Identifier: Unlicense

#ifndef DATA_H
#define DATA_H

#include "typedefs.h"
#include <vector>

namespace Data
{
  namespace Texture
  {
#ifdef SHR3D_FONT_BITMAP
    inline constexpr i32 fontBitmapWidth = 96;
    inline constexpr i32 fontBitmapHeight = 60;
    extern const u8 fontBitmap[5760];
#endif // SHR3D_FONT_BITMAP
#ifdef SHR3D_FONT_MSDF
    struct GlyphInfo
    {
      i32 width;
      char32_t byteOffset;
    };
    struct CodepointGlyphInfo
    {
      char32_t codepoint;
      GlyphInfo glyphInfo;
    };
    extern const CodepointGlyphInfo codepointGlyphInfos[217];
    extern const u8 fontMSDF[374880];
#endif // SHR3D_FONT_MSDF

#ifdef __ANDROID__
    extern const u8 texture_astc[350224];
#ifdef SHR3D_OPENXR
#ifdef SHR3D_OPENXR_CONTROLLER_PICO4
    extern const u8 xrController_Pico4_astc[350224];
#endif // SHR3D_OPENXR_CONTROLLER_PICO4
#ifdef SHR3D_OPENXR_CONTROLLER_QUEST3
    extern const u8 xrController_Quest3_Left_astc[1400848];
    extern const u8 xrController_Quest3_Right_astc[1400848];
#endif // SHR3D_OPENXR_CONTROLLER_QUEST3
#endif // SHR3D_OPENXR
#else // __ANDROID
    extern const u8 texture_dds[1048704];
#ifdef SHR3D_OPENXR
#ifdef SHR3D_OPENXR_CONTROLLER_PICO4
    extern const u8 xrController_Pico4_dds[1048704];
#endif // SHR3D_OPENXR_CONTROLLER_PICO4
#ifdef SHR3D_OPENXR_CONTROLLER_QUEST3
    extern const u8 xrController_Quest3_Left_dds[1048704];
    extern const u8 xrController_Quest3_Right_dds[1048704];
#endif // SHR3D_OPENXR_CONTROLLER_QUEST3
#endif // SHR3D_OPENXR
#endif // __ANDROID
#if defined(SHR3D_OPENXR) || (defined(SHR3D_CUSTOM_CURSOR) && defined(SHR3D_WINDOW_SDL))
    extern const u8 cursor[65536];
#endif
#if defined(SHR3D_CUSTOM_CURSOR) && defined(SHR3D_WINDOW_WIN32)
    extern const u8 cursorWin32[65536];
#endif // SHR3D_CUSTOM_CURSOR && SHR3D_WINDOW_WIN32

    extern const u8 codePen[36864];
    extern const u8 debug[36864];
    extern const u8 documentary[36864];
    extern const u8 eject[36864];
    extern const u8 exit[36864];
    extern const u8 fullscreen[36864];
    extern const u8 futures[36864];
    extern const u8 guitarAmp[36864];
    extern const u8 guitarStrings[36864];
    extern const u8 metronome[36864];
    extern const u8 milk[36864];
    extern const u8 mute[36864];
    extern const u8 newWindow[36864];
    extern const u8 record[36864];
    extern const u8 repeat[36864];
    extern const u8 snowflake[36864];
    extern const u8 tuningFork[36864];
    extern const u8 unicast[36864];
    extern const u8 voltmeter[36864];
    extern const u8 tasks[36864];
    extern const u8 directions[36864];
#ifdef SHR3D_OPENXR_PCVR
    extern const u8 virtualReality[36864];
#endif // SHR3D_OPENXR_PCVR
  }
#ifdef SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON
  namespace Convolotron
  {
    extern const f32 impulseResponse0[3999];
    extern const f32 impulseResponse1[3999];
    extern const f32 impulseResponse2[2216];
    extern const f32 impulseResponse3[1463];
    extern const f32 impulseResponse4[3999];
    extern const f32 impulseResponse5[3999];
    extern const f32 impulseResponse6[3999];
    extern const f32 impulseResponse7[1086];
    extern const f32 impulseResponse8[3999];
  }
#endif // SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON

#ifdef SHR3D_ENVIRONMENT_MILK
  extern const u8 M_data[27965];
  extern const u8 headphones_data[22402];
#endif // SHR3D_ENVIRONMENT_MILK
}

#endif // DATA_H
