// SPDX-License-Identifier: Unlicense

#ifndef DEBUG_H
#define DEBUG_H

#include "typedefs.h"

#ifdef PLATFORM_WINDOWS
#ifndef NDEBUG

#include <vector>

namespace Debug
{
  // For rapid prototyping.
  // Models can be exported as Obj files in Blender.
  struct ObjFileHotReloadContext
  {
    time_t lastModifiedTime;
    std::vector<f32> vertices;
  };
  void drawObjFileHotReload(ObjFileHotReloadContext& ctx, const char8_t* objFileToMonitor);
}

#endif // NDEBUG

#endif // DEBUG_H
#endif // PLATFORM_WINDOWS
