// SPDX-License-Identifier: Unlicense

#ifndef GEOMETRY_H
#define GEOMETRY_H

#include "typedefs.h"

namespace Geometry
{
//#ifndef SHR3D_OPENGL_DRAW_NON_INDEXED
  enum struct Vertices : u32
  {
    planeY = 4,
    planeZ = 4,
    planeZFlippedV = 4,
    fret = 120,
    string = 14,
    capo = 72,
    noteArpeggio = 16,
    noteZeroArpeggioLeft = 11,
    noteZeroArpeggioRight = 11,
    noteBendStepFull = 18,
    noteBendStepHalf = 18,
    noteHex = 18,
    noteRect = 12,
    noteFretboard = 168,
    noteStand = 14,
    noteSymbolFretMute = 335,
    noteSymbolHammerOn = 334,
    noteSymbolHarmonic = 369,
    noteSymbolPalmMute = 373,
    noteSymbolPinchHarmonic = 50,
    noteSymbolPop = 252,
    noteSymbolPullOff = 451,
    noteSymbolSlap = 254,
    noteSymbolTap = 581,
    noteSymbolSlimX = 39,
    noteSymbolTriangleDown = 9,
    noteSymbolSlimEye = 384,
    noteSymbolWideEye = 582,
    noteSymbolWideX = 50,
    noteSymbolWideUpsideV = 128,
    noteSymbolTriangleUp = 7,
    noteSymbolWideOffsetV = 128,
    noteSymbolWideV = 26,
    noteSymbolSineRight = 152,
    noteSymbolSineLeft = 152,
    noteZeroLeft = 11,
    noteZeroMiddle = 20,
    noteZeroRight = 11,
    particle0 = 4,
    particle1 = 4,
    particle2 = 4,
#ifndef PLATFORM_EMSCRIPTEN
#ifdef SHR3D_OPENXR
    xrDebugAxis = 68,
#ifdef SHR3D_OPENXR_CONTROLLER_PICO4
    xrController_Pico4Left = 2798,
    xrController_Pico4Right = 2806,
#endif // SHR3D_OPENXR_CONTROLLER_PICO4
#ifdef SHR3D_OPENXR_CONTROLLER_QUEST3
    xrController_Quest3Left = 3977,
    xrController_Quest3Right = 3977,
#endif // SHR3D_OPENXR_CONTROLLER_QUEST3
    xrPointer = 66,
#endif // SHR3D_OPENXR
#ifdef SHR3D_ENVIRONMENT_SKYBOX
    skysphere = 2143,
#endif // SHR3D_ENVIRONMENT_SKYBOX
#ifdef SHR3D_NOTE_CUTS
    note25vl = 14,
    note25vr = 14,
    note375vl = 14,
    note375vr = 14,
    note50hb = 14,
    note50ht = 14,
    note50vl = 14,
    note50vr = 14,
    note625vl = 14,
    note625vr = 14,
    note75vl = 14,
    note75vr = 14,
#endif // SHR3D_NOTE_CUTS
#endif // PLATFORM_EMSCRIPTEN
  };
  enum struct Indicies : u32
  {
    planeY = 6,
    planeZ = 6,
    planeZFlippedV = 6,
    fret = 627,
    string = 36,
    capo = 420,
    noteArpeggio = 36,
    noteZeroArpeggioLeft = 24,
    noteZeroArpeggioRight = 24,
    noteBendStepFull = 48,
    noteBendStepHalf = 48,
    noteHex = 48,
    noteRect = 30,
    noteFretboard = 492,
    noteStand = 36,
    noteSymbolFretMute = 801,
    noteSymbolHammerOn = 828,
    noteSymbolHarmonic = 1098,
    noteSymbolPalmMute = 879,
    noteSymbolPinchHarmonic = 219,
    noteSymbolPop = 576,
    noteSymbolPullOff = 1080,
    noteSymbolSlap = 1131,
    noteSymbolTap = 1368,
    noteSymbolSlimX = 108,
    noteSymbolTriangleDown = 21,
    noteSymbolSlimEye = 1722,
    noteSymbolWideEye = 1722,
    noteSymbolWideX = 138,
    noteSymbolWideUpsideV = 372,
    noteSymbolTriangleUp = 15,
    noteSymbolWideOffsetV = 372,
    noteSymbolWideV = 66,
    noteSymbolSineRight = 678,
    noteSymbolSineLeft = 678,
    noteZeroLeft = 27,
    noteZeroMiddle = 54,
    noteZeroRight = 27,
    particle0 = 6,
    particle1 = 6,
    particle2 = 6,
#ifndef PLATFORM_EMSCRIPTEN
#ifdef SHR3D_OPENXR
    xrDebugAxis = 108,
#ifdef SHR3D_OPENXR_CONTROLLER_PICO4
    xrController_Pico4Left = 13557,
    xrController_Pico4Right = 13557,
#endif // SHR3D_OPENXR_CONTROLLER_PICO4
#ifdef SHR3D_OPENXR_CONTROLLER_QUEST3
    xrController_Quest3Left = 16827,
    xrController_Quest3Right = 16827,
#endif // SHR3D_OPENXR_CONTROLLER_QUEST3
    xrPointer = 192,
#endif // SHR3D_OPENXR
#ifdef SHR3D_ENVIRONMENT_SKYBOX
    skysphere = 11904,
#endif // SHR3D_ENVIRONMENT_SKYBOX
#ifdef SHR3D_NOTE_CUTS
    note25vl = 30,
    note25vr = 30,
    note375vl = 30,
    note375vr = 30,
    note50hb = 30,
    note50ht = 30,
    note50vl = 30,
    note50vr = 30,
    note625vl = 30,
    note625vr = 30,
    note75vl = 30,
    note75vr = 30,
#endif // SHR3D_NOTE_CUTS
#endif // PLATFORM_EMSCRIPTEN
  };
//#ifdef SHR3D_OPENGL_DRAW_ZERO_BASED
//  enum struct BaseVertex : u32
//  {
//    planeY = 0,
//    planeZ = planeY + to_underlying_(Geometry::Vertices::planeY),
//    planeZFlippedV = planeZ + to_underlying_(Geometry::Vertices::planeZ),
//    fret = planeZFlippedV + to_underlying_(Geometry::Vertices::planeZFlippedV),
//    string = fret + to_underlying_(Geometry::Vertices::fret),
//    capo = string + to_underlying_(Geometry::Vertices::string),
//    noteArpeggio = capo + to_underlying_(Geometry::Vertices::capo),
//    noteZeroArpeggioLeft = noteArpeggio + to_underlying_(Geometry::Vertices::noteArpeggio),
//    noteZeroArpeggioRight = noteZeroArpeggioLeft + to_underlying_(Geometry::Vertices::noteZeroArpeggioLeft),
//    noteBendStepFull = noteZeroArpeggioRight + to_underlying_(Geometry::Vertices::noteZeroArpeggioRight),
//    noteBendStepHalf = noteBendStepFull + to_underlying_(Geometry::Vertices::noteBendStepFull),
//    noteHex = noteBendStepHalf + to_underlying_(Geometry::Vertices::noteBendStepHalf),
//    noteRect = noteHex + to_underlying_(Geometry::Vertices::noteHex),
//    noteFretboard = noteRect + to_underlying_(Geometry::Vertices::noteRect),
//    noteStand = noteFretboard + to_underlying_(Geometry::Vertices::noteFretboard),
//    noteSymbolFretMute = noteStand + to_underlying_(Geometry::Vertices::noteStand),
//    noteSymbolHammerOn = noteSymbolFretMute + to_underlying_(Geometry::Vertices::noteSymbolFretMute),
//    noteSymbolHarmonic = noteSymbolHammerOn + to_underlying_(Geometry::Vertices::noteSymbolHammerOn),
//    noteSymbolPalmMute = noteSymbolHarmonic + to_underlying_(Geometry::Vertices::noteSymbolHarmonic),
//    noteSymbolPinchHarmonic = noteSymbolPalmMute + to_underlying_(Geometry::Vertices::noteSymbolPalmMute),
//    noteSymbolPop = noteSymbolPinchHarmonic + to_underlying_(Geometry::Vertices::noteSymbolPinchHarmonic),
//    noteSymbolPullOff = noteSymbolPop + to_underlying_(Geometry::Vertices::noteSymbolPop),
//    noteSymbolSlap = noteSymbolPullOff + to_underlying_(Geometry::Vertices::noteSymbolPullOff),
//    noteSymbolTap = noteSymbolSlap + to_underlying_(Geometry::Vertices::noteSymbolSlap),
//    noteSymbolSlimX = noteSymbolTap + to_underlying_(Geometry::Vertices::noteSymbolTap),
//    noteSymbolTriangleDown = noteSymbolSlimX + to_underlying_(Geometry::Vertices::noteSymbolSlimX),
//    noteSymbolSlimEye = noteSymbolTriangleDown + to_underlying_(Geometry::Vertices::noteSymbolTriangleDown),
//    noteSymbolWideEye = noteSymbolSlimEye + to_underlying_(Geometry::Vertices::noteSymbolSlimEye),
//    noteSymbolWideX = noteSymbolWideEye + to_underlying_(Geometry::Vertices::noteSymbolWideEye),
//    noteSymbolWideUpsideV = noteSymbolWideX + to_underlying_(Geometry::Vertices::noteSymbolWideX),
//    noteSymbolTriangleUp = noteSymbolWideUpsideV + to_underlying_(Geometry::Vertices::noteSymbolWideUpsideV),
//    noteSymbolWideOffsetV = noteSymbolTriangleUp + to_underlying_(Geometry::Vertices::noteSymbolTriangleUp),
//    noteSymbolWideV = noteSymbolWideOffsetV + to_underlying_(Geometry::Vertices::noteSymbolWideOffsetV),
//    noteSymbolSineRight = noteSymbolWideV + to_underlying_(Geometry::Vertices::noteSymbolWideV),
//    noteSymbolSineLeft = noteSymbolSineRight + to_underlying_(Geometry::Vertices::noteSymbolSineRight),
//    noteZeroLeft = noteSymbolSineLeft + to_underlying_(Geometry::Vertices::noteSymbolSineLeft),
//    noteZeroMiddle = noteZeroLeft + to_underlying_(Geometry::Vertices::noteZeroLeft),
//    noteZeroRight = noteZeroMiddle + to_underlying_(Geometry::Vertices::noteZeroMiddle),
//    particle0 = noteZeroRight + to_underlying_(Geometry::Vertices::noteZeroRight),
//    particle1 = particle0 + to_underlying_(Geometry::Vertices::particle0),
//    particle2 = particle1 + to_underlying_(Geometry::Vertices::particle1),
//    // code below will not work except when all options are enabled
//#ifdef SHR3D_OPENXR
//    xrDebugAxis = particle2 + to_underlying_(Geometry::Vertices::particle2),
//#ifdef SHR3D_OPENXR_CONTROLLER_PICO4
//    xrController_Pico4Left = xrDebugAxis + to_underlying_(Geometry::Vertices::xrDebugAxis),
//    xrController_Pico4Right = xrController_Pico4Left + to_underlying_(Geometry::Vertices::xrController_Pico4Left),
//#endif // SHR3D_OPENXR_CONTROLLER_PICO4
//#ifdef SHR3D_OPENXR_CONTROLLER_QUEST3
//    xrController_Quest3Left = xrController_Pico4Right + to_underlying_(Geometry::Vertices::xrController_Pico4Right),
//    xrController_Quest3Right = xrController_Quest3Left + to_underlying_(Geometry::Vertices::xrController_Quest3Left),
//#endif // SHR3D_OPENXR_CONTROLLER_QUEST3
//    xrPointer = xrController_Quest3Right + to_underlying_(Geometry::Vertices::xrController_Quest3Right),
//#endif // SHR3D_OPENXR
//#ifdef SHR3D_ENVIRONMENT_SKYBOX
//    skysphere = xrPointer + to_underlying_(Geometry::Vertices::xrPointer),
//#endif // SHR3D_ENVIRONMENT_SKYBOX
//#ifdef SHR3D_NOTE_CUTS
//    note25vl = skysphere + to_underlying_(Geometry::Vertices::skysphere),
//    note25vr = note25vl + to_underlying_(Geometry::Vertices::note25vl),
//    note375vl = note25vr + to_underlying_(Geometry::Vertices::note25vr),
//    note375vr = note375vl + to_underlying_(Geometry::Vertices::note375vl),
//    note50hb = note375vr + to_underlying_(Geometry::Vertices::note375vr),
//    note50ht = note50hb + to_underlying_(Geometry::Vertices::note50hb),
//    note50vl = note50ht + to_underlying_(Geometry::Vertices::note50ht),
//    note50vr = note50vl + to_underlying_(Geometry::Vertices::note50vl),
//    note625vl = note50vr + to_underlying_(Geometry::Vertices::note50vr),
//    note625vr = note625vl + to_underlying_(Geometry::Vertices::note625vl),
//    note75vl = note625vr + to_underlying_(Geometry::Vertices::note625vr),
//    note75vr = note75vl + to_underlying_(Geometry::Vertices::note75vl),
//#endif // SHR3D_NOTE_CUTS
//  };
//#endif // SHR3D_OPENGL_DRAW_ZERO_BASED
  enum struct IndicesOffset : u32
  {
    planeY = 0,
    planeZ = planeY + to_underlying_(Geometry::Indicies::planeY),
    planeZFlippedV = planeZ + to_underlying_(Geometry::Indicies::planeZ),
    fret = planeZFlippedV + to_underlying_(Geometry::Indicies::planeZFlippedV),
    string = fret + to_underlying_(Geometry::Indicies::fret),
    capo = string + to_underlying_(Geometry::Indicies::string),
    noteArpeggio = capo + to_underlying_(Geometry::Indicies::capo),
    noteZeroArpeggioLeft = noteArpeggio + to_underlying_(Geometry::Indicies::noteArpeggio),
    noteZeroArpeggioRight = noteZeroArpeggioLeft + to_underlying_(Geometry::Indicies::noteZeroArpeggioLeft),
    noteBendStepFull = noteZeroArpeggioRight + to_underlying_(Geometry::Indicies::noteZeroArpeggioRight),
    noteBendStepHalf = noteBendStepFull + to_underlying_(Geometry::Indicies::noteBendStepFull),
    noteHex = noteBendStepHalf + to_underlying_(Geometry::Indicies::noteBendStepHalf),
    noteRect = noteHex + to_underlying_(Geometry::Indicies::noteHex),
    noteFretboard = noteRect + to_underlying_(Geometry::Indicies::noteRect),
    noteStand = noteFretboard + to_underlying_(Geometry::Indicies::noteFretboard),
    noteSymbolFretMute = noteStand + to_underlying_(Geometry::Indicies::noteStand),
    noteSymbolHammerOn = noteSymbolFretMute + to_underlying_(Geometry::Indicies::noteSymbolFretMute),
    noteSymbolHarmonic = noteSymbolHammerOn + to_underlying_(Geometry::Indicies::noteSymbolHammerOn),
    noteSymbolPalmMute = noteSymbolHarmonic + to_underlying_(Geometry::Indicies::noteSymbolHarmonic),
    noteSymbolPinchHarmonic = noteSymbolPalmMute + to_underlying_(Geometry::Indicies::noteSymbolPalmMute),
    noteSymbolPop = noteSymbolPinchHarmonic + to_underlying_(Geometry::Indicies::noteSymbolPinchHarmonic),
    noteSymbolPullOff = noteSymbolPop + to_underlying_(Geometry::Indicies::noteSymbolPop),
    noteSymbolSlap = noteSymbolPullOff + to_underlying_(Geometry::Indicies::noteSymbolPullOff),
    noteSymbolTap = noteSymbolSlap + to_underlying_(Geometry::Indicies::noteSymbolSlap),
    noteSymbolSlimX = noteSymbolTap + to_underlying_(Geometry::Indicies::noteSymbolTap),
    noteSymbolTriangleDown = noteSymbolSlimX + to_underlying_(Geometry::Indicies::noteSymbolSlimX),
    noteSymbolSlimEye = noteSymbolTriangleDown + to_underlying_(Geometry::Indicies::noteSymbolTriangleDown),
    noteSymbolWideEye = noteSymbolSlimEye + to_underlying_(Geometry::Indicies::noteSymbolSlimEye),
    noteSymbolWideX = noteSymbolWideEye + to_underlying_(Geometry::Indicies::noteSymbolWideEye),
    noteSymbolWideUpsideV = noteSymbolWideX + to_underlying_(Geometry::Indicies::noteSymbolWideX),
    noteSymbolTriangleUp = noteSymbolWideUpsideV + to_underlying_(Geometry::Indicies::noteSymbolWideUpsideV),
    noteSymbolWideOffsetV = noteSymbolTriangleUp + to_underlying_(Geometry::Indicies::noteSymbolTriangleUp),
    noteSymbolWideV = noteSymbolWideOffsetV + to_underlying_(Geometry::Indicies::noteSymbolWideOffsetV),
    noteSymbolSineRight = noteSymbolWideV + to_underlying_(Geometry::Indicies::noteSymbolWideV),
    noteSymbolSineLeft = noteSymbolSineRight + to_underlying_(Geometry::Indicies::noteSymbolSineRight),
    noteZeroLeft = noteSymbolSineLeft + to_underlying_(Geometry::Indicies::noteSymbolSineLeft),
    noteZeroMiddle = noteZeroLeft + to_underlying_(Geometry::Indicies::noteZeroLeft),
    noteZeroRight = noteZeroMiddle + to_underlying_(Geometry::Indicies::noteZeroMiddle),
    particle0 = noteZeroRight + to_underlying_(Geometry::Indicies::noteZeroRight),
    particle1 = particle0 + to_underlying_(Geometry::Indicies::particle0),
    particle2 = particle1 + to_underlying_(Geometry::Indicies::particle1),
#ifndef PLATFORM_EMSCRIPTEN
#ifdef SHR3D_OPENXR
    xrDebugAxis = particle2 + to_underlying_(Geometry::Indicies::particle2),
#ifdef SHR3D_OPENXR_CONTROLLER_PICO4
    xrController_Pico4Left = xrDebugAxis + to_underlying_(Geometry::Indicies::xrDebugAxis),
    xrController_Pico4Right = xrController_Pico4Left + to_underlying_(Geometry::Indicies::xrController_Pico4Left),
#endif // SHR3D_OPENXR_CONTROLLER_PICO4
#ifdef SHR3D_OPENXR_CONTROLLER_QUEST3
    xrController_Quest3Left = xrController_Pico4Right + to_underlying_(Geometry::Indicies::xrController_Pico4Right),
    xrController_Quest3Right = xrController_Quest3Left + to_underlying_(Geometry::Indicies::xrController_Quest3Left),
#endif // SHR3D_OPENXR_CONTROLLER_QUEST3
    xrPointer = xrController_Quest3Right + to_underlying_(Geometry::Indicies::xrController_Quest3Right),
#endif // SHR3D_OPENXR
#ifdef SHR3D_ENVIRONMENT_SKYBOX
    skysphere = xrPointer + to_underlying_(Geometry::Indicies::xrPointer),
#endif // SHR3D_ENVIRONMENT_SKYBOX
#ifdef SHR3D_NOTE_CUTS
    note25vl = skysphere + to_underlying_(Geometry::Indicies::skysphere),
    note25vr = note25vl + to_underlying_(Geometry::Indicies::note25vl),
    note375vl = note25vr + to_underlying_(Geometry::Indicies::note25vr),
    note375vr = note375vl + to_underlying_(Geometry::Indicies::note375vl),
    note50hb = note375vr + to_underlying_(Geometry::Indicies::note375vr),
    note50ht = note50hb + to_underlying_(Geometry::Indicies::note50hb),
    note50vl = note50ht + to_underlying_(Geometry::Indicies::note50ht),
    note50vr = note50vl + to_underlying_(Geometry::Indicies::note50vl),
    note625vl = note50vr + to_underlying_(Geometry::Indicies::note50vr),
    note625vr = note625vl + to_underlying_(Geometry::Indicies::note625vl),
    note75vl = note625vr + to_underlying_(Geometry::Indicies::note625vr),
    note75vr = note75vl + to_underlying_(Geometry::Indicies::note75vl),
#endif // SHR3D_NOTE_CUTS
#endif // PLATFORM_EMSCRIPTEN
  };
//#else // SHR3D_OPENGL_DRAW_NON_INDEXED
//  enum struct Vertices
//  {
//    planeY = 6,
//    planeZ = 6,
//    planeZFlippedV = 6,
//    fret = 627,
//    string = 36,
//    capo = 420,
//    noteArpeggio = 36,
//    noteZeroArpeggioLeft = 24,
//    noteZeroArpeggioRight = 24,
//    noteBendStepFull = 48,
//    noteBendStepHalf = 48,
//    noteHex = 48,
//    noteRect = 30,
//    noteFretboard = 492,
//    noteStand = 36,
//    noteSymbolFretMute = 801,
//    noteSymbolHammerOn = 828,
//    noteSymbolHarmonic = 1098,
//    noteSymbolPalmMute = 879,
//    noteSymbolPinchHarmonic = 219,
//    noteSymbolPop = 576,
//    noteSymbolPullOff = 1080,
//    noteSymbolSlap = 1131,
//    noteSymbolTap = 1368,
//    noteSymbolSlimX = 108,
//    noteSymbolTriangleDown = 21,
//    noteSymbolSlimEye = 1722,
//    noteSymbolWideEye = 1722,
//    noteSymbolWideX = 138,
//    noteSymbolWideUpsideV = 372,
//    noteSymbolTriangleUp = 15,
//    noteSymbolWideOffsetV = 372,
//    noteSymbolWideV = 66,
//    noteSymbolSineRight = 678,
//    noteSymbolSineLeft = 678,
//    noteZeroLeft = 27,
//    noteZeroMiddle = 54,
//    noteZeroRight = 27,
//    particle0 = 6,
//    particle1 = 6,
//    particle2 = 6,
//#ifdef SHR3D_OPENXR
//    xrDebugAxis = 108,
//#ifdef SHR3D_OPENXR_CONTROLLER_PICO4
//    xrController_Pico4Left = 13557,
//    xrController_Pico4Right = 13557,
//#endif // SHR3D_OPENXR_CONTROLLER_PICO4
//#ifdef SHR3D_OPENXR_CONTROLLER_QUEST3
//    xrController_Quest3Left = 16827,
//    xrController_Quest3Right = 16827,
//#endif // SHR3D_OPENXR_CONTROLLER_QUEST3
//    xrPointer = 192,
//#endif // SHR3D_OPENXR
//#ifdef SHR3D_ENVIRONMENT_SKYBOX
//    skysphere = 11904,
//#endif // SHR3D_ENVIRONMENT_SKYBOX
//  };
//  enum struct VerticesOffset
//  {
//    planeY = 0,
//    planeZ = planeY + to_underlying_(Geometry::Vertices::planeY),
//    planeZFlippedV = planeZ + to_underlying_(Geometry::Vertices::planeZ),
//    fret = planeZFlippedV + to_underlying_(Geometry::Vertices::planeZFlippedV),
//    string = fret + to_underlying_(Geometry::Vertices::fret),
//    capo = string + to_underlying_(Geometry::Vertices::string),
//    noteArpeggio = capo + to_underlying_(Geometry::Vertices::capo),
//    noteZeroArpeggioLeft = noteArpeggio + to_underlying_(Geometry::Vertices::noteArpeggio),
//    noteZeroArpeggioRight = noteZeroArpeggioLeft + to_underlying_(Geometry::Vertices::noteZeroArpeggioLeft),
//    noteBendStepFull = noteZeroArpeggioRight + to_underlying_(Geometry::Vertices::noteZeroArpeggioRight),
//    noteBendStepHalf = noteBendStepFull + to_underlying_(Geometry::Vertices::noteBendStepFull),
//    noteHex = noteBendStepHalf + to_underlying_(Geometry::Vertices::noteBendStepHalf),
//    noteRect = noteHex + to_underlying_(Geometry::Vertices::noteHex),
//    noteFretboard = noteRect + to_underlying_(Geometry::Vertices::noteRect),
//    noteStand = noteFretboard + to_underlying_(Geometry::Vertices::noteFretboard),
//    noteSymbolFretMute = noteStand + to_underlying_(Geometry::Vertices::noteStand),
//    noteSymbolHammerOn = noteSymbolFretMute + to_underlying_(Geometry::Vertices::noteSymbolFretMute),
//    noteSymbolHarmonic = noteSymbolHammerOn + to_underlying_(Geometry::Vertices::noteSymbolHammerOn),
//    noteSymbolPalmMute = noteSymbolHarmonic + to_underlying_(Geometry::Vertices::noteSymbolHarmonic),
//    noteSymbolPinchHarmonic = noteSymbolPalmMute + to_underlying_(Geometry::Vertices::noteSymbolPalmMute),
//    noteSymbolPop = noteSymbolPinchHarmonic + to_underlying_(Geometry::Vertices::noteSymbolPinchHarmonic),
//    noteSymbolPullOff = noteSymbolPop + to_underlying_(Geometry::Vertices::noteSymbolPop),
//    noteSymbolSlap = noteSymbolPullOff + to_underlying_(Geometry::Vertices::noteSymbolPullOff),
//    noteSymbolTap = noteSymbolSlap + to_underlying_(Geometry::Vertices::noteSymbolSlap),
//    noteSymbolSlimX = noteSymbolTap + to_underlying_(Geometry::Vertices::noteSymbolTap),
//    noteSymbolTriangleDown = noteSymbolSlimX + to_underlying_(Geometry::Vertices::noteSymbolSlimX),
//    noteSymbolSlimEye = noteSymbolTriangleDown + to_underlying_(Geometry::Vertices::noteSymbolTriangleDown),
//    noteSymbolWideEye = noteSymbolSlimEye + to_underlying_(Geometry::Vertices::noteSymbolSlimEye),
//    noteSymbolWideX = noteSymbolWideEye + to_underlying_(Geometry::Vertices::noteSymbolWideEye),
//    noteSymbolWideUpsideV = noteSymbolWideX + to_underlying_(Geometry::Vertices::noteSymbolWideX),
//    noteSymbolTriangleUp = noteSymbolWideUpsideV + to_underlying_(Geometry::Vertices::noteSymbolWideUpsideV),
//    noteSymbolWideOffsetV = noteSymbolTriangleUp + to_underlying_(Geometry::Vertices::noteSymbolTriangleUp),
//    noteSymbolWideV = noteSymbolWideOffsetV + to_underlying_(Geometry::Vertices::noteSymbolWideOffsetV),
//    noteSymbolSineRight = noteSymbolWideV + to_underlying_(Geometry::Vertices::noteSymbolWideV),
//    noteSymbolSineLeft = noteSymbolSineRight + to_underlying_(Geometry::Vertices::noteSymbolSineRight),
//    noteZeroLeft = noteSymbolSineLeft + to_underlying_(Geometry::Vertices::noteSymbolSineLeft),
//    noteZeroMiddle = noteZeroLeft + to_underlying_(Geometry::Vertices::noteZeroLeft),
//    noteZeroRight = noteZeroMiddle + to_underlying_(Geometry::Vertices::noteZeroMiddle),
//    particle0 = noteZeroRight + to_underlying_(Geometry::Vertices::noteZeroRight),
//    particle1 = particle0 + to_underlying_(Geometry::Vertices::particle0),
//    particle2 = particle1 + to_underlying_(Geometry::Vertices::particle1),
//    // code below will not work except when all options are enabled
//#ifdef SHR3D_OPENXR
//    xrDebugAxis = particle2 + to_underlying_(Geometry::Vertices::particle2),
//#ifdef SHR3D_OPENXR_CONTROLLER_PICO4
//    xrController_Pico4Left = xrDebugAxis + to_underlying_(Geometry::Vertices::xrDebugAxis),
//    xrController_Pico4Right = xrController_Pico4Left + to_underlying_(Geometry::Vertices::xrController_Pico4Left),
//#endif // SHR3D_OPENXR_CONTROLLER_PICO4
//#ifdef SHR3D_OPENXR_CONTROLLER_QUEST3
//    xrController_Quest3Left = xrController_Pico4Right + to_underlying_(Geometry::Vertices::xrController_Pico4Right),
//    xrController_Quest3Right = xrController_Quest3Left + to_underlying_(Geometry::Vertices::xrController_Quest3Left),
//#endif // SHR3D_OPENXR_CONTROLLER_QUEST3
//    xrPointer = xrController_Quest3Right + to_underlying_(Geometry::Vertices::xrController_Quest3Right),
//#endif // SHR3D_OPENXR
//#ifdef SHR3D_ENVIRONMENT_SKYBOX
//    skysphere = xrPointer + to_underlying_(Geometry::Vertices::xrPointer),
//#endif // SHR3D_ENVIRONMENT_SKYBOX
//  };
//#endif // SHR3D_OPENGL_DRAW_NON_INDEXED

  void init();
}

#endif // GEOMETRY_H
