// SPDX-License-Identifier: Unlicense

#ifndef GLSL_H
#define GLSL_H

#include "typedefs.h"

#ifndef SHR3D_OPENGL_SPIR_V

namespace Glsl
{
  extern const char* screenVert;
  extern const char* screenFrag;
  extern const char* worldVert;
  extern const char* worldFrag;
  extern const char* worldNoTextureVert;
  extern const char* worldNoTextureFrag;
  extern const char* modelFrag;
  extern const char* modelUvNotFlippedFrag;
  extern const char* worldVUMeterMonoFrag;
  extern const char* worldVUMeterStereoFrag;
  extern const char* worldTunerFrag;
  extern const char* worldTunerInFretFrag;
  extern const char* highwayFadeFarVert;
  extern const char* highwayFadeFarAndNearVert;
  extern const char* highwayFadeFarFrag;
  extern const char* collisionChordFrag;
  extern const char* collisionFretFrag;
  extern const char* collisionNoteFrag;
  extern const char* dotInlayFrag;
  extern const char* groundFretFrag;
#ifdef SHR3D_FONT_BITMAP
  extern const char* fontFrag;
  extern const char* fontWorldFadeFarFrag;
  extern const char* fontWorldFadeFarAndNearFrag;
  extern const char* fontRainbowScreenFrag;
  //extern const char* fontRainbowWorldFrag;
#endif //SHR3D_FONT_BITMAP
#ifdef SHR3D_FONT_MSDF
  extern const char* fontMSDFFrag;
  extern const char* fontMSDFWorldFadeFarFrag;
  extern const char* fontMSDFWorldFadeFarAndNearFrag;
  extern const char* fontMSDFRainbowScreenFrag;
#endif //SHR3D_FONT_MSDF
  extern const char* groundAnchorFrag;
  extern const char* groundBeatFrag;
  extern const char* groundBeatStrumDirectionFrag;
  extern const char* chordBoxFrag;
  extern const char* chordBoxDoubleStopFrag;
  extern const char* chordBoxHighDensityFrag;
  extern const char* chordBoxHighDensityDoubleStopFrag;
  extern const char* chordBoxFretMuteFrag;
  extern const char* chordBoxPalmMuteFrag;
  extern const char* chordBoxArpeggioFrag;
#ifdef SHR3D_MUSIC_STRETCHER
  extern const char* timelineMusicStretcherFrag;
#endif //SHR3D_MUSIC_STRETCHER
  extern const char* timelineSimpleFrag;
  extern const char* timelineToneFrag;
  extern const char* timelineLevelFrag;
  extern const char* groundSustainFrag;
  extern const char* fretVert;
  extern const char* scoreScreenFrag;
  extern const char* stringFrag;
  extern const char* stringWoundFrag;
  extern const char* sustainFrag;
  extern const char* noteAccentFrag;
  extern const char* noteStandFrag;
  extern const char* noteStandZeroFrag;

#ifdef SHR3D_RENDERER_DEVELOPMENT
  extern const char* highwayFadeFarInstancedVert;
  extern const char* highwayFadeFarInstancedFrag;
#endif // SHR3D_RENDERER_DEVELOPMENT

#ifdef SHR3D_PARTICLE
  extern const char* particleInstancedVert;
  extern const char* particleInstancedFrag;
#endif // SHR3D_PARTICLE

  extern const char* uiVert;
  extern const char* uiFrag;

#ifdef SHR3D_OPENXR
  extern const char* xrPointerFrag;
#endif // SHR3D_OPENXR

#ifdef SHR3D_ENVIRONMENT_SKYBOX
  extern const char* skyboxFrag;
#endif // SHR3D_ENVIRONMENT_SKYBOX
#ifdef SHR3D_ENVIRONMENT_SKYBOX_CUBE_TEXTURE
  extern const char* skyboxCubeTextureVert;
  extern const char* skyboxCubeTextureFrag;
#endif // SHR3D_ENVIRONMENT_SKYBOX_CUBE_TEXTURE
}

#endif // SHR3D_OPENGL_SPIR_V

#endif // GLSL_H
