// SPDX-License-Identifier: Unlicense

#ifndef INI_H
#define INI_H

#include "typedefs.h"

#include <string>
#include <vector>
#include <map>

namespace Ini
{
  std::map<std::u8string, std::map<std::u8string, std::u8string>> loadIniContent(const char8_t* str, u64 strSize);
  struct KeyValue
  {
    std::u8string key;
    std::u8string value;
  };
  std::map<std::u8string, std::vector<KeyValue>> loadIniContent_keepKeyOrder(const char8_t* str, u64 strSize);

  void saveIniFile(const char8_t* filePath, const std::map<std::u8string, std::map<std::u8string, std::u8string>>& iniContent);
  struct SectionKeyValue
  {
    std::u8string section;
    std::map<std::u8string, std::u8string> keyValues;
  };
  void saveIniFile_keepSectionOrder(const char8_t* filePath, const std::vector<SectionKeyValue>& iniContent);
}

#endif // INI_H
