// SPDX-License-Identifier: Unlicense

#ifndef OGG_H
#define OGG_H

#include "typedefs.h"

namespace Ogg
{
  struct vorbis;

  struct Info
  {
    u32 sample_rate;
    i32 channels;
    u32 setup_memory_required;
    u32 setup_temp_memory_required;
    u32 temp_memory_required;
    i32 max_frame_size;
  };

  vorbis* open(const u8* data, i32 len);
  void close(vorbis* f);

  Info getInfo(vorbis* f);

  i32 decodeMemory(vorbis* f, f32** output);
}

#endif // OGG_H