// SPDX-License-Identifier: Unlicense

#ifndef PARTICLE_H
#define PARTICLE_H

#include "configuration.h"

#ifdef SHR3D_PARTICLE

#include "type.h"

namespace Particle
{
  struct HighwaySpawn
  {
    vec3 position;
    f32 width;
    f32 height;
    vec4 color;
    f32 spawnMultiplier;
  };

  void highwayFretboardSpawn(const HighwaySpawn& highwaySpawn);
  void render(const mat4& highwayViewProjectionMat);
}

#endif // SHR3D_PARTICLE

#endif // PARTICLE_H
