// SPDX-License-Identifier: Unlicense

#ifndef SFX_H
#define SFX_H

#include "typedefs.h"

#ifdef SHR3D_SFX

#include "type.h"

#include <map>
#include <string>
#include <vector>

struct Rect;

namespace Sfx
{
  extern std::map<SfxSystem, std::vector<std::u8string>> names;

  SfxSystem name2SfxSystem(const char8_t* name);
  const char8_t* sfxSystem2Name(SfxSystem sfxSystem);

  void init();

#ifdef SHR3D_SFX_PLUGIN
  bool hasSfxPluginWIndow(SfxId sfxId);
  void openSfxPluginWindow(SfxId sfxId, i32 instance, Shr3DWindow parentWindow);
  Size getSfxPluginWIndowSize(SfxId sfxId, i32 instance);
  void closeSfxPluginWindow(SfxId sfxId, i32 instance);

  i32 numParams(SfxId sfxId, i32 instance);
  void getParameterProperties(SfxId sfxId, i32 instance, i32 param, SfxParameterProperties& parameterProperties);
  f32 getParameter(SfxId sfxId, i32 instance, i32 param);
  void setParameter(SfxId sfxId, i32 instance, i32 param, f32 value);
#endif // SHR3D_SFX_PLUGIN

  ProcessBlockResult processBlock(SfxId sfxId, i32 instance, f32** inBlock, f32** outBlock, i32 blockSize);

  std::u8string saveParameters(SfxId sfxId, i32 instance);
  void loadParameters(SfxId sfxId, i32 instance, const std::u8string& parameters);

#ifdef SHR3D_SFX_PLUGIN
  bool sfxSystemIsPlugin(SfxSystem sfxSystem);
#endif // SHR3D_SFX_PLUGIN
}

#endif // SHR3D_SFX

#endif // SFX_H
