/* ========================================
 *  ADClip8 - ADClip8.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __ADClip8_ADClip8_H
#define __ADClip8_ADClip8_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::ADClip8 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class ADClip8 final : public SfxCoreExtensionV1
{
public:
    ADClip8();
    ~ADClip8();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

	double lastSampleL[8];
	double intermediateL[16][8];
	bool wasPosClipL[8];
	bool wasNegClipL[8];
	double lastSampleR[8];
	double intermediateR[16][8];
	bool wasPosClipR[8];
	bool wasNegClipR[8];
	
    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
