/* ========================================
 *  ADT - ADT.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "ADT.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::ADT {

ADT::ADT()
{
	A = 0.5; //0.0 to 2.0 headroom
	B = 0.5; //delay time
	C = 0.5; //-1.0  to 1.0 inv/out
	D = 0.5; //delay time
	E = 0.5; //-1.0 to 1.0 inv/out
	F = 0.5; //0.0 to 2.0 output level
	
	for(int count = 0; count < 9999; count++) {pL[count] = 0; pR[count] = 0;}
	offsetA = 9001;
	offsetB = 9001;  //  :D
	gcount = 0;	
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int ADT::getParameterCount() const
{
  return kNumParameters;
}

void ADT::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float ADT::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void ADT::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Headrm", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "A Delay", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "A Level", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "B Delay", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "B Level", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Output", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void ADT::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A*2.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string ((C*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string ((E*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamF: float2string (F*2.0, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void ADT::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
