/* ========================================
 *  AQuickVoiceClip - AQuickVoiceClip.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __AQuickVoiceClip_AQuickVoiceClip_H
#define __AQuickVoiceClip_AQuickVoiceClip_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::AQuickVoiceClip {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class AQuickVoiceClip final : public SfxCoreExtensionV1
{
public:
    AQuickVoiceClip();
    ~AQuickVoiceClip();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	
	double LataLast6Sample;
	double LataLast5Sample;
	double LataLast4Sample;
	double LataLast3Sample;
	double LataLast2Sample;
	double LataLast1Sample;
	double LataHalfwaySample;
	double LataHalfDrySample;
	double LataHalfDiffSample;
	double LataLastDiffSample;
	double LataDrySample;
	double LataDiffSample;
	double LataPrevDiffSample;
	
	double RataLast6Sample;
	double RataLast5Sample;
	double RataLast4Sample;
	double RataLast3Sample;
	double RataLast2Sample;
	double RataLast1Sample;
	double RataHalfwaySample;
	double RataHalfDrySample;
	double RataHalfDiffSample;
	double RataLastDiffSample;
	double RataDrySample;
	double RataDiffSample;
	double RataPrevDiffSample;
	
	double ataK1;
	double ataK2;
	double ataK3;
	double ataK4;
	double ataK5;
	double ataK6;
	double ataK7;
	double ataK8; //end antialiasing variables

	double LlastSample;
	double LlastOutSample;
	double LlastOut2Sample;
	double LlastOut3Sample;
	double LlpDepth;
	double Lovershoot;
	double Loverall;
	double LiirSampleA;
	double LiirSampleB;
	double LiirSampleC;
	double LiirSampleD;

	double RlastSample;
	double RlastOutSample;
	double RlastOut2Sample;
	double RlastOut3Sample;
	double RlpDepth;
	double Rovershoot;
	double Roverall;
	double RiirSampleA;
	double RiirSampleB;
	double RiirSampleC;
	double RiirSampleD;
	bool flip;
		
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
