/* ========================================
 *  BrassRider - BrassRider.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __BrassRider_BrassRider_H
#define __BrassRider_BrassRider_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::BrassRider {
enum {
	kParamA = 0,
	kParamB = 1,
	kNumParameters = 2
}; //


class BrassRider final : public SfxCoreExtensionV1
{
public:
    BrassRider();
    ~BrassRider();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double d[80002];
	double e[80002];
	double highIIRL;
	double slewIIRL;
	double highIIR2L;
	double slewIIR2L;
	double highIIRR;
	double slewIIRR;
	double highIIR2R;
	double slewIIR2R;
	double control;
	double clamp;
	double lastSampleL;
	double lastSlewL;
	double lastSampleR;
	double lastSlewR;
	int gcount;
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
