/* ========================================
 *  BuildATPDF - BuildATPDF.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __BuildATPDF_BuildATPDF_H
#define __BuildATPDF_BuildATPDF_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::BuildATPDF {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
	kParamG = 6,
	kParamH = 7,
	kParamI = 8,
	kParamJ = 9,
  kNumParameters = 10
}; //


class BuildATPDF final : public SfxCoreExtensionV1
{
public:
    BuildATPDF();
    ~BuildATPDF();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double bL[11];
	double bR[11];
	double f[11];		
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
    float G;
    float H;
    float I;
    float J;
	//parameters. Always 0-1, and we scale/alter them elsewhere.
	uint32_t fpdL;
	uint32_t fpdR;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
