/* ========================================
 *  Chamber - Chamber.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Chamber_Chamber_H
#define __Chamber_Chamber_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Chamber {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
  kNumParameters = 5
}; //


class Chamber final : public SfxCoreExtensionV1
{
public:
    Chamber();
    ~Chamber();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double iirAL;
	double iirBL;
	double iirCL;
	
	double aEL[20000];
	double aFL[12361];
	double aGL[7640];
	double aHL[4722];
	double aAL[2916];
	double aBL[1804];
	double aCL[1115];
	double aDL[689];
	double aIL[426];
	double aJL[264];
	double aKL[163];
	double aLL[101];
	
	double feedbackAL;
	double feedbackBL;
	double feedbackCL;
	double feedbackDL;
	double previousAL;
	double previousBL;
	double previousCL;
	double previousDL;
	
	double lastRefL[10];
	
	double iirAR;
	double iirBR;
	double iirCR;
	
	double aER[20000];
	double aFR[12361];
	double aGR[7640];
	double aHR[4722];
	double aAR[2916];
	double aBR[1804];
	double aCR[1115];
	double aDR[689];
	double aIR[426];
	double aJR[264];
	double aKR[163];
	double aLR[101];
	
	double feedbackAR;
	double feedbackBR;
	double feedbackCR;
	double feedbackDR;
	double previousAR;
	double previousBR;
	double previousCR;
	double previousDR;
	
	double lastRefR[10];
	
	int countA, delayA;
	int countB, delayB;
	int countC, delayC;
	int countD, delayD;
	int countE, delayE;
	int countF, delayF;
	int countG, delayG;
	int countH, delayH;
	int countI, delayI;
	int countJ, delayJ;
	int countK, delayK;
	int countL, delayL;
	int cycle; //all these ints are shared across channels, not duplicated	
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
