/* ========================================
 *  Channel9 - Channel9.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Channel9.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Channel9 {

Channel9::Channel9()
{
	A = 0.0;
	B = 0.0;
	C = 1.0;
	for (int x = 0; x < 15; x++) {biquadA[x] = 0.0; biquadB[x] = 0.0;}
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	iirSampleLA = 0.0;
	iirSampleRA = 0.0;
	iirSampleLB = 0.0;
	iirSampleRB = 0.0;
	lastSampleAL = lastSampleBL = lastSampleCL = 0.0;
	lastSampleAR = lastSampleBR = lastSampleCR = 0.0;
	flip = false;
	iirAmount = 0.005832;
	threshold = 0.33362176; //instantiating with Neve values
	cutoff = 28811.0;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Channel9::getParameterCount() const
{
  return kNumParameters;
}

void Channel9::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
	switch((int)( A * 4.999 ))
	{  
		case 0: iirAmount = 0.005832; threshold = 0.33362176; cutoff = 28811.0; break; //Neve
		case 1: iirAmount = 0.004096; threshold = 0.59969536; cutoff = 27216.0; break; //API
		case 2: iirAmount = 0.004913; threshold = 0.84934656; cutoff = 23011.0; break; //SSL
		case 3: iirAmount = 0.009216; threshold = 0.149; cutoff = 18544.0; break; //Teac
		case 4: iirAmount = 0.011449; threshold = 0.092; cutoff = 19748.0; break; //Mackie
		default: break; //should not happen
	}
}

float Channel9::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Channel9::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Console Type", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Drive", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Output", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Channel9::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 4.999 )) //0 to almost edge of # of params
		{	case 0: strncpy (text, "Neve", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "API", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "SSL", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "Teac", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "Mackie", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break; //completed consoletype 'popup' parameter, exit
		case kParamB: int2string ((int)(B*200), text, kVstMaxParamStrLen); break;
		case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Channel9::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "%", kVstMaxParamStrLen); break; //the percent
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break; //the percent
		default: break; // unknown parameter, shouldn't happen!
    }
}





} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
