/* ========================================
 *  Console0Channel - Console0Channel.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Console0Channel_Console0Channel_H
#define __Console0Channel_Console0Channel_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Console0Channel {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class Console0Channel final : public SfxCoreExtensionV1
{
public:
    Console0Channel();
    ~Console0Channel();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double avgAL;
	double avgAR;
	double avgBL;
	double avgBR;	
    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
