/* ========================================
 *  Console8BussOut - Console8BussOut.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Console8BussOut_Console8BussOut_H
#define __Console8BussOut_Console8BussOut_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Console8BussOut {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class Console8BussOut final : public SfxCoreExtensionV1
{
public:
    Console8BussOut();
    ~Console8BussOut();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double inTrimA;
	double inTrimB;
	bool hsr;
	enum {
		fix_freq,
		fix_reso,
		fix_a0,
		fix_a1,
		fix_a2,
		fix_b1,
		fix_b2,
		fix_sL1,
		fix_sL2,
		fix_sR1,
		fix_sR2,
		fix_total
	}; //fixed frequency biquad filter for ultrasonics, stereo
	double fix[fix_total];
	
	double lastSampleL;
	double intermediateL[18];
	bool wasPosClipL;
	bool wasNegClipL; //ClipOnly2
	
	double lastSampleR;
	double intermediateR[18];
	bool wasPosClipR;
	bool wasNegClipR;
	
	int spacing;
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
