/* ========================================
 *  Creature - Creature.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Creature_Creature_H
#define __Creature_Creature_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Creature {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class Creature final : public SfxCoreExtensionV1
{
public:
    Creature();
    ~Creature();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

	double slewL[102]; //probably worth just using a number here
	double slewR[102]; //probably worth just using a number here

    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
