/* ========================================
 *  DarkNoise - DarkNoise.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __DarkNoise_DarkNoise_H
#define __DarkNoise_DarkNoise_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::DarkNoise {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class DarkNoise final : public SfxCoreExtensionV1
{
public:
    DarkNoise();
    ~DarkNoise();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double rL[8193];
	double bL[11][11];
	double lastRandyL;
	double outputNoiseL;
	
	double rR[8193];
	double bR[11][11];
	double lastRandyR;
	double outputNoiseR;
	
	int freq;
	double f[11];		

	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
