/* ========================================
 *  DeEss - DeEss.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "DeEss.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::DeEss {

DeEss::DeEss()
{
	A = 0.0;
	B = 0.5; //-48.0 to 0.0
	C = 0.5;
	
	s1L = s2L = s3L = s4L = s5L = s6L= s7L = 0.0;
	m1L = m2L = m3L = m4L = m5L = m6L = 0.0;
	c1L = c2L = c3L = c4L = c5L = 0.0;
	ratioAL = ratioBL = 1.0;
	iirSampleAL = 0.0;
	iirSampleBL = 0.0;
	
	s1R = s2R = s3R = s4R = s5R = s6R = s7R = 0.0;
	m1R = m2R = m3R = m4R = m5R = m6R = 0.0;
	c1R = c2R = c3R = c4R = c5R = 0.0;
	ratioAR = ratioBR = 1.0;
	iirSampleAR = 0.0;
	iirSampleBR = 0.0;
	
	flip = false;	
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int DeEss::getParameterCount() const
{
  return kNumParameters;
}

void DeEss::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float DeEss::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void DeEss::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Intense", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Max DS", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Freq", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void DeEss::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B-1.0)*48.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void DeEss::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
