/* ========================================
 *  DeHiss - DeHiss.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __DeHiss_DeHiss_H
#define __DeHiss_DeHiss_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::DeHiss {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class DeHiss final : public SfxCoreExtensionV1
{
public:
    DeHiss();
    ~DeHiss();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double storedL[2];
	double diffL[6];
	double gateL;
	double rawL;

	double storedR[2];
	double diffR[6];
	double gateR;
	double rawR;

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
