/* ========================================
 *  Ditherbox - Ditherbox.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Ditherbox.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Ditherbox {

Ditherbox::Ditherbox()
{
	A = 0.86;

	Position = 99999999;
	contingentErrL = 0.0;
	contingentErrR = 0.0;
	currentDitherL = 0.0;
	currentDitherR = 0.0;
	bynL[0] = 1000;
	bynL[1] = 301;
	bynL[2] = 176;
	bynL[3] = 125;
	bynL[4] = 97;
	bynL[5] = 79;
	bynL[6] = 67;
	bynL[7] = 58;
	bynL[8] = 51;
	bynL[9] = 46;
	bynL[10] = 1000;
	noiseShapingL = 0.0;
	bynR[0] = 1000;
	bynR[1] = 301;
	bynR[2] = 176;
	bynR[3] = 125;
	bynR[4] = 97;
	bynR[5] = 79;
	bynR[6] = 67;
	bynR[7] = 58;
	bynR[8] = 51;
	bynR[9] = 46;
	bynR[10] = 1000;
	noiseShapingR = 0.0;
	
	NSOddL = 0.0;
	prevL = 0.0;
	nsL[0] = 0;
	nsL[1] = 0;
	nsL[2] = 0;
	nsL[3] = 0;
	nsL[4] = 0;
	nsL[5] = 0;
	nsL[6] = 0;
	nsL[7] = 0;
	nsL[8] = 0;
	nsL[9] = 0;
	nsL[10] = 0;
	nsL[11] = 0;
	nsL[12] = 0;
	nsL[13] = 0;
	nsL[14] = 0;
	nsL[15] = 0;
	NSOddR = 0.0;
	prevR = 0.0;
	nsR[0] = 0;
	nsR[1] = 0;
	nsR[2] = 0;
	nsR[3] = 0;
	nsR[4] = 0;
	nsR[5] = 0;
	nsR[6] = 0;
	nsR[7] = 0;
	nsR[8] = 0;
	nsR[9] = 0;
	nsR[10] = 0;
	nsR[11] = 0;
	nsR[12] = 0;
	nsR[13] = 0;
	nsR[14] = 0;
	nsR[15] = 0;

	lastSampleL = 0.0;
	outSampleL = 0.0;
	lastSampleR = 0.0;
	outSampleR = 0.0;

	iirSampleAL = 0.0;
	iirSampleBL = 0.0;
	iirSampleCL = 0.0;
	iirSampleDL = 0.0;
	iirSampleEL = 0.0;
	iirSampleFL = 0.0;
	iirSampleGL = 0.0;
	iirSampleHL = 0.0;
	iirSampleIL = 0.0;
	iirSampleJL = 0.0;
	iirSampleKL = 0.0;
	iirSampleLL = 0.0;
	iirSampleML = 0.0;
	iirSampleNL = 0.0;
	iirSampleOL = 0.0;
	iirSamplePL = 0.0;
	iirSampleQL = 0.0;
	iirSampleRL = 0.0;
	iirSampleSL = 0.0;
	iirSampleTL = 0.0;
	iirSampleUL = 0.0;
	iirSampleVL = 0.0;
	iirSampleWL = 0.0;
	iirSampleXL = 0.0;
	iirSampleYL = 0.0;
	iirSampleZL = 0.0;
	
	iirSampleAR = 0.0;
	iirSampleBR = 0.0;
	iirSampleCR = 0.0;
	iirSampleDR = 0.0;
	iirSampleER = 0.0;
	iirSampleFR = 0.0;
	iirSampleGR = 0.0;
	iirSampleHR = 0.0;
	iirSampleIR = 0.0;
	iirSampleJR = 0.0;
	iirSampleKR = 0.0;
	iirSampleLR = 0.0;
	iirSampleMR = 0.0;
	iirSampleNR = 0.0;
	iirSampleOR = 0.0;
	iirSamplePR = 0.0;
	iirSampleQR = 0.0;
	iirSampleRR = 0.0;
	iirSampleSR = 0.0;
	iirSampleTR = 0.0;
	iirSampleUR = 0.0;
	iirSampleVR = 0.0;
	iirSampleWR = 0.0;
	iirSampleXR = 0.0;
	iirSampleYR = 0.0;
	iirSampleZR = 0.0;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Ditherbox::getParameterCount() const
{
  return kNumParameters;
}

void Ditherbox::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Ditherbox::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Ditherbox::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Type", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Ditherbox::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 24.999 )) //0 to almost edge of # of params
		{
			case 0: strncpy (text, "Trunc", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Flat", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "TPDF", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "Paul", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "DbPaul", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "Tape", kVstMaxParamStrLen); break;
			case 6: strncpy (text, "HiGloss", kVstMaxParamStrLen); break;
			case 7: strncpy (text, "Vinyl", kVstMaxParamStrLen); break;
			case 8: strncpy (text, "Spatial", kVstMaxParamStrLen); break;
			case 9: strncpy (text, "Natural", kVstMaxParamStrLen); break;
			case 10: strncpy (text, "NJAD", kVstMaxParamStrLen); break;
			case 11: strncpy (text, "Trunc", kVstMaxParamStrLen); break;
			case 12: strncpy (text, "Flat", kVstMaxParamStrLen); break;
			case 13: strncpy (text, "TPDF", kVstMaxParamStrLen); break;
			case 14: strncpy (text, "Paul", kVstMaxParamStrLen); break;
			case 15: strncpy (text, "DbPaul", kVstMaxParamStrLen); break;
			case 16: strncpy (text, "Tape", kVstMaxParamStrLen); break;
			case 17: strncpy (text, "HiGloss", kVstMaxParamStrLen); break;
			case 18: strncpy (text, "Vinyl", kVstMaxParamStrLen); break;
			case 19: strncpy (text, "Spatial", kVstMaxParamStrLen); break;
			case 20: strncpy (text, "Natural", kVstMaxParamStrLen); break;
			case 21: strncpy (text, "NJAD", kVstMaxParamStrLen); break;
			case 22: strncpy (text, "SlewOnl", kVstMaxParamStrLen); break;
			case 23: strncpy (text, "SubsOnl", kVstMaxParamStrLen); break;
			case 24: strncpy (text, "Silhoue", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break;			
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Ditherbox::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 24.999 )) //0 to almost edge of # of params
		{
			case 0: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 6: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 7: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 8: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 9: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 10: strncpy (text, "16", kVstMaxParamStrLen); break;
			case 11: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 12: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 13: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 14: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 15: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 16: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 17: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 18: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 19: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 20: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 21: strncpy (text, "24", kVstMaxParamStrLen); break;
			case 22: strncpy (text, "y", kVstMaxParamStrLen); break;
			case 23: strncpy (text, "y", kVstMaxParamStrLen); break;
			case 24: strncpy (text, "tte", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break;			
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
