/* ========================================
 *  Doublelay - Doublelay.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Doublelay_Doublelay_H
#define __Doublelay_Doublelay_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Doublelay {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
  kNumParameters = 5
}; //


class Doublelay final : public SfxCoreExtensionV1
{
public:
    Doublelay();
    ~Doublelay();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double dL[48010];
	double dR[48010];
	int dcount;
	double pL[5010];
	double pR[5010];
	int gcountL;
	int lastcountL;
	int gcountR;
	int lastcountR;
	int prevwidth;
	double trackingL[9];
	double tempL[9];
	double positionL[9];
	double lastpositionL[9];
	double trackingR[9];
	double tempR[9];
	double positionR[9];
	double lastpositionR[9];
	int activeL;
	int bestspliceL;
	int activeR;
	int bestspliceR;
	double feedbackL;
	double feedbackR;
	double bestyetL;
	double bestyetR;
	double airPrevL;
	double airEvenL;
	double airOddL;
	double airFactorL;
	double airPrevR;
	double airEvenR;
	double airOddR;
	double airFactorR;
	bool flip;
	
	double lastRefL[7];
	double lastRefR[7];
	int cycle;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
