/* ========================================
 *  DubCenter - DubCenter.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __DubCenter_DubCenter_H
#define __DubCenter_DubCenter_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::DubCenter {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
	kParamG = 6,
	kParamH = 7,
	kParamI = 8,
	kParamJ = 9,
	kNumParameters = 10
}; //


class DubCenter final : public SfxCoreExtensionV1
{
public:
    DubCenter();
    ~DubCenter();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double iirDriveSampleAL;
	double iirDriveSampleBL;
	double iirDriveSampleCL;
	double iirDriveSampleDL;
	double iirDriveSampleEL;
	double iirDriveSampleFL;
	double iirDriveSampleAR;
	double iirDriveSampleBR;
	double iirDriveSampleCR;
	double iirDriveSampleDR;
	double iirDriveSampleER;
	double iirDriveSampleFR;
	bool flip; //drive things
	
	int bflip;
	bool WasNegative;
	bool SubOctave;
	double iirHeadBumpA;
	double iirHeadBumpB;
	double iirHeadBumpC;
	
	double iirSubBumpA;
	double iirSubBumpB;
	double iirSubBumpC;
	
	double lastHeadBump;
	double lastSubBump;
	
	double iirSampleA;
	double iirSampleB;
	double iirSampleC;
	double iirSampleD;
	double iirSampleE;
	double iirSampleF;
	double iirSampleG;
	double iirSampleH;
	double iirSampleI;
	double iirSampleJ;
	double iirSampleK;
	double iirSampleL;
	double iirSampleM;
	double iirSampleN;
	double iirSampleO;
	double iirSampleP;
	double iirSampleQ;
	double iirSampleR;
	double iirSampleS;
	double iirSampleT;
	double iirSampleU;
	double iirSampleV;
	double iirSampleW;
	double iirSampleX;
	double iirSampleY;
	double iirSampleZ;		
	double oscGate;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
    float G;
    float H;
    float I;
    float J;
	
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
