/* ========================================
 *  DubSub - DubSub.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __DubSub_DubSub_H
#define __DubSub_DubSub_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::DubSub {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
	kParamG = 6,
	kParamH = 7,
	kParamI = 8,
	kParamJ = 9,
  kNumParameters = 10
}; //


class DubSub final : public SfxCoreExtensionV1
{
public:
    DubSub();
    ~DubSub();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	
private:		
	double iirDriveSampleAL;
	double iirDriveSampleBL;
	double iirDriveSampleCL;
	double iirDriveSampleDL;
	double iirDriveSampleEL;
	double iirDriveSampleFL;
	double iirDriveSampleAR;
	double iirDriveSampleBR;
	double iirDriveSampleCR;
	double iirDriveSampleDR;
	double iirDriveSampleER;
	double iirDriveSampleFR;
	bool flip; //drive things
	
	int bflip;
	bool WasNegativeL;
	bool SubOctaveL;
	bool WasNegativeR;
	bool SubOctaveR;
	
	double iirHeadBumpAL;
	double iirHeadBumpBL;
	double iirHeadBumpCL;
	double iirHeadBumpAR;
	double iirHeadBumpBR;
	double iirHeadBumpCR;
	
	double iirSubBumpAL;
	double iirSubBumpBL;
	double iirSubBumpCL;
	double iirSubBumpAR;
	double iirSubBumpBR;
	double iirSubBumpCR;
	
	double lastHeadBumpL;
	double lastSubBumpL;
	double lastHeadBumpR;
	double lastSubBumpR;
	
	double iirSampleAL;
	double iirSampleBL;
	double iirSampleCL;
	double iirSampleDL;
	double iirSampleEL;
	double iirSampleFL;
	double iirSampleGL;
	double iirSampleHL;
	double iirSampleIL;
	double iirSampleJL;
	double iirSampleKL;
	double iirSampleLL;
	double iirSampleML;
	double iirSampleNL;
	double iirSampleOL;
	double iirSamplePL;
	double iirSampleQL;
	double iirSampleRL;
	double iirSampleSL;
	double iirSampleTL;
	double iirSampleUL;
	double iirSampleVL;
	double iirSampleWL;
	double iirSampleXL;
	double iirSampleYL;
	double iirSampleZL;
	double iirSampleAR;
	double iirSampleBR;
	double iirSampleCR;
	double iirSampleDR;
	double iirSampleER;
	double iirSampleFR;
	double iirSampleGR;
	double iirSampleHR;
	double iirSampleIR;
	double iirSampleJR;
	double iirSampleKR;
	double iirSampleLR;
	double iirSampleMR;
	double iirSampleNR;
	double iirSampleOR;
	double iirSamplePR;
	double iirSampleQR;
	double iirSampleRR;
	double iirSampleSR;
	double iirSampleTR;
	double iirSampleUR;
	double iirSampleVR;
	double iirSampleWR;
	double iirSampleXR;
	double iirSampleYR;
	double iirSampleZR;
	
	double oscGateL;
	double oscGateR;
	
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
    float G;
    float H;
    float I;
    float J;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
