/* ========================================
 *  Elation - Elation.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Elation_Elation_H
#define __Elation_Elation_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Elation {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class Elation final : public SfxCoreExtensionV1
{
public:
    Elation();
    ~Elation();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double compAL;
	double compBL;
	double compCL;
	double compDL;
	double previousL;
	double previousBL;
	double compAR;
	double compBR;
	double compCR;
	double compDR;
	double previousR;
	double previousBR;
	bool flip;

	
	double bR[35];
	double lastSampleR;
	double bL[35];
	double lastSampleL;
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
