/* ========================================
 *  ElectroHat - ElectroHat.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "ElectroHat.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::ElectroHat {

ElectroHat::ElectroHat()
{
	A = 0.0;
	B = 0.5;
	C = 1.0;
	D = 0.1;
	E = 1.0;
	storedSampleL = 0.0;
	storedSampleR = 0.0;
	lastSampleL = 0.0;
	lastSampleR = 0.0;
	tik = 3746926;
	lok = 0;
	flip = true;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int ElectroHat::getParameterCount() const
{
  return kNumParameters;
}

void ElectroHat::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float ElectroHat::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void ElectroHat::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "HiHat", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Trim", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Bright", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Output", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void ElectroHat::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 5.999 )) //0 to almost edge of # of params
		{
			case 0: strncpy (text, "Syn Hat", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Electro", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "Dense", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "606 St", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "808 St", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "909 St", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
			
			
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void ElectroHat::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
