/* ========================================
 *  FathomFive - FathomFive.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __FathomFive_FathomFive_H
#define __FathomFive_FathomFive_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::FathomFive {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //

const int kNumPrograms = 1;

class FathomFive final : public SfxCoreExtensionV1
{
public:
    FathomFive();
    ~FathomFive();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
	  float getParameter(int index) override;                   // get the parameter value at the specified index
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    	
	bool WasNegativeL;
	bool SubOctaveL;
	double iirSampleLA;
	double iirSampleLB;
	double iirSampleLC;
	double iirSampleLD;

	bool WasNegativeR;
	bool SubOctaveR;
	double iirSampleRA;
	double iirSampleRB;
	double iirSampleRC;
	double iirSampleRD;
	
    float A; //Root Note
    float B; //SubOctave
    float C; //Frequency
    float D; //Dry/Wet
	//parameters. Always 0-1, and we scale/alter them elsewhere.
	uint32_t fpdL;
	uint32_t fpdR;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
