/* ========================================
 *  Floor - Floor.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Floor_Floor_H
#define __Floor_Floor_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Floor {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class Floor final : public SfxCoreExtensionV1
{
public:
    Floor();
    ~Floor();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
	
	bool flip; //end defining of antialiasing variables
    
	double iirSample1AL;
	double iirSample1BL;
	double iirSample1CL;
	double iirSample1DL;
	double iirSample1EL;
	double iirSample2AL;
	double iirSample2BL;
	double iirSample2CL;
	double iirSample2DL;
	double iirSample2EL;

	double iirSample1AR;
	double iirSample1BR;
	double iirSample1CR;
	double iirSample1DR;
	double iirSample1ER;
	double iirSample2AR;
	double iirSample2BR;
	double iirSample2CR;
	double iirSample2DR;
	double iirSample2ER;	
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
