/* ========================================
 *  Focus - Focus.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Focus.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Focus {

Focus::Focus()
{
	A = 0.0;
	B = 0.5;
	C = 0.5;
	D = 1.0;
	E = 1.0;
	for (int x = 0; x < 9; x++) {figureL[x] = 0.0;figureR[x] = 0.0;}
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Focus::getParameterCount() const
{
  return kNumParameters;
}

void Focus::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Focus::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Focus::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Boost", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Focus", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Mode", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Output", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Focus::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A*12.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: switch((int)( C * 4.999 )) //0 to almost edge of # of params
		{
			case 0: strncpy (text, "Density", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Drive", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "Spiral", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "Mojo", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "Dyno", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Focus::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
