/* ========================================
 *  GlitchShifter - GlitchShifter.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __GlitchShifter_GlitchShifter_H
#define __GlitchShifter_GlitchShifter_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::GlitchShifter {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
  kNumParameters = 5
}; //


class GlitchShifter final : public SfxCoreExtensionV1
{
public:
    GlitchShifter();
    ~GlitchShifter();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    	
	int pL[131076];
	int offsetL[258];
	int pastzeroL[258];
	int previousL[258];
	int thirdL[258];
	int fourthL[258];
	int tempL;
	int lasttempL;
	int thirdtempL;
	int fourthtempL;
	int sincezerocrossL;
	int crossesL;
	int realzeroesL;
	double positionL;
	bool splicingL;
	
	double airPrevL;
	double airEvenL;
	double airOddL;
	double airFactorL;
	
	int pR[131076];
	int offsetR[258];
	int pastzeroR[258];
	int previousR[258];
	int thirdR[258];
	int fourthR[258];
	int tempR;
	int lasttempR;
	int thirdtempR;
	int fourthtempR;
	int sincezerocrossR;
	int crossesR;
	int realzeroesR;
	double positionR;
	bool splicingR;
	
	double airPrevR;
	double airEvenR;
	double airOddR;
	double airFactorR;
	
	int gcount;
	int lastwidth;
	bool flip;
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
