/* ========================================
 *  Hermepass - Hermepass.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Hermepass.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Hermepass {

Hermepass::Hermepass()
{
	A = 0.5;
	B = 0.5;
	
	iirAL = 0.0;
	iirBL = 0.0;
	iirCL = 0.0;
	iirDL = 0.0;
	iirEL = 0.0;
	iirFL = 0.0;
	iirGL = 0.0;
	iirHL = 0.0;

	iirAR = 0.0;
	iirBR = 0.0;
	iirCR = 0.0;
	iirDR = 0.0;
	iirER = 0.0;
	iirFR = 0.0;
	iirGR = 0.0;
	iirHR = 0.0;
	fpFlip = true;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Hermepass::getParameterCount() const
{
  return kNumParameters;
}

void Hermepass::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Hermepass::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Hermepass::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Cutoff", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Slope", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Hermepass::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Hermepass::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
