/* ========================================
 *  Huge - Huge.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Huge.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Huge {

Huge::Huge()
{
	A = 0.2;
	B = 0.2;

	prev3L = prev5L = prev7L = prev9L = prev11L = prev13L = prevOutL = 0.0;
	limit3L = limit5L = limit7L = limit9L = limit11L = limit13L = 1.0;
	prev3R = prev5R = prev7R = prev9R = prev11R = prev13R = prevOutR = 0.0;
	limit3R = limit5R = limit7R = limit9R = limit11R = limit13R = 1.0;

	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Huge::getParameterCount() const
{
  return kNumParameters;
}

void Huge::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Huge::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Huge::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Huge", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Nasty", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Huge::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Huge::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
