/* ========================================
 *  MoNoam - MoNoam.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "MoNoam.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::MoNoam {

MoNoam::MoNoam()
{
	A = 0.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int MoNoam::getParameterCount() const
{
  return kNumParameters;
}

void MoNoam::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float MoNoam::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void MoNoam::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Monotor", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void MoNoam::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 7.999 )) //0 to almost edge of # of params
		{	case 0: strncpy (text, "Bypass", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Mono", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "MonoR", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "MonoL", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "Side", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "SideM", kVstMaxParamStrLen); break;
			case 6: strncpy (text, "SideR", kVstMaxParamStrLen); break;
			case 7: strncpy (text, "SideL", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break;			
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void MoNoam::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
