/* ========================================
 *  Monitoring - Monitoring.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Monitoring_Monitoring_H
#define __Monitoring_Monitoring_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Monitoring {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class Monitoring final : public SfxCoreExtensionV1
{
public:
    Monitoring();
    ~Monitoring();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double bynL[13], bynR[13];
	double noiseShapingL, noiseShapingR;
	//NJAD
	double aL[1503], bL[1503], cL[1503], dL[1503];
	double aR[1503], bR[1503], cR[1503], dR[1503];
	int ax, bx, cx, dx;
	//PeaksOnly
	double lastSampleL, lastSampleR;
	//SlewOnly
	double iirSampleAL, iirSampleBL, iirSampleCL, iirSampleDL, iirSampleEL, iirSampleFL, iirSampleGL;
	double iirSampleHL, iirSampleIL, iirSampleJL, iirSampleKL, iirSampleLL, iirSampleML, iirSampleNL, iirSampleOL, iirSamplePL;
	double iirSampleQL, iirSampleRL, iirSampleSL;
	double iirSampleTL, iirSampleUL, iirSampleVL;
	double iirSampleWL, iirSampleXL, iirSampleYL, iirSampleZL;
	
	double iirSampleAR, iirSampleBR, iirSampleCR, iirSampleDR, iirSampleER, iirSampleFR, iirSampleGR;
	double iirSampleHR, iirSampleIR, iirSampleJR, iirSampleKR, iirSampleLR, iirSampleMR, iirSampleNR, iirSampleOR, iirSamplePR;
	double iirSampleQR, iirSampleRR, iirSampleSR;
	double iirSampleTR, iirSampleUR, iirSampleVR;
	double iirSampleWR, iirSampleXR, iirSampleYR, iirSampleZR; // o/`
	//SubsOnly
	double biquadL[11];
	double biquadR[11];
	//Bandpasses

	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
