/* ========================================
 *  Noise - Noise.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Noise.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Noise {

Noise::Noise()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	D = 1.0;
	E = 0.0;
	F = 1.0;
	position = 99999999;
	quadratic = 0;
	noiseAL = 0.0;
	noiseBL = 0.0;
	noiseCL = 0.0;
	rumbleAL = 0.0;
	rumbleBL = 0.0;
	surgeL = 0.0;
	noiseAR = 0.0;
	noiseBR = 0.0;
	noiseCR = 0.0;
	rumbleAR = 0.0;
	rumbleBR = 0.0;
	surgeR = 0.0;
	flipL = false;
	flipR = false;
	filterflip = false;	
	for(int count = 0; count < 11; count++) {bL[count] = 0.0; bR[count] = 0.0; f[count] = 0.0;}
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Noise::getParameterCount() const
{
  return kNumParameters;
}

void Noise::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Noise::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Noise::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "HighCut", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "LowCut", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "LShape", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Decay", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Distnc", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Noise::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        case kParamF: float2string (F, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Noise::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
