/* ========================================
 *  Noise - Noise.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Noise_Noise_H
#define __Noise_Noise_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Noise {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
  kNumParameters = 6
}; //


class Noise final : public SfxCoreExtensionV1
{
public:
    Noise();
    ~Noise();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double noiseAL;
	double noiseBL;
	double noiseCL;
	double rumbleAL;
	double rumbleBL;
	double surgeL;
	double noiseAR;
	double noiseBR;
	double noiseCR;
	double rumbleAR;
	double rumbleBR;
	double surgeR;
	
	int position;
	int quadratic;
	bool flipL;
	bool flipR;
	bool filterflip;
	
	double bL[11];
	double bR[11];

	double f[11];
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
