/* ========================================
 *  OneCornerClip - OneCornerClip.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "OneCornerClip.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::OneCornerClip {

OneCornerClip::OneCornerClip()
{
	A = 0.33333333333333333;
	B = 0.966;
	C = 0.966;
	D = 0.618;
	E = 1.0;
	
	lastSampleL = 0.0;
	limitPosL = 0.0;
	limitNegL = 0.0;
	lastSampleR = 0.0;
	limitPosR = 0.0;
	limitNegR = 0.0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int OneCornerClip::getParameterCount() const
{
  return kNumParameters;
}

void OneCornerClip::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float OneCornerClip::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void OneCornerClip::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Input", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Pos Thr", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Neg Thr", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Voicing", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void OneCornerClip::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*36.0)-12.0, text, kVstMaxParamStrLen); break;
        case kParamB: dB2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: dB2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void OneCornerClip::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
