/* ========================================
 *  Pear2 - Pear2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Pear2_Pear2_H
#define __Pear2_Pear2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Pear2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class Pear2 final : public SfxCoreExtensionV1
{
public:
    Pear2();
    ~Pear2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	enum {
		prevSampL1,
		prevSlewL1,
		prevSampR1,
		prevSlewR1,
		prevSampL2,
		prevSlewL2,
		prevSampR2,
		prevSlewR2,
		prevSampL3,
		prevSlewL3,
		prevSampR3,
		prevSlewR3,
		prevSampL4,
		prevSlewL4,
		prevSampR4,
		prevSlewR4,
		prevSampL5,
		prevSlewL5,
		prevSampR5,
		prevSlewR5,
		prevSampL6,
		prevSlewL6,
		prevSampR6,
		prevSlewR6,
		prevSampL7,
		prevSlewL7,
		prevSampR7,
		prevSlewR7,
		prevSampL8,
		prevSlewL8,
		prevSampR8,
		prevSlewR8,
		prevSampL9,
		prevSlewL9,
		prevSampR9,
		prevSlewR9,
		prevSampL10,
		prevSlewL10,
		prevSampR10,
		prevSlewR10,
		prevSampL11,
		prevSlewL11,
		prevSampR11,
		prevSlewR11,
		prevSampL12,
		prevSlewL12,
		prevSampR12,
		prevSlewR12,
		prevSampL13,
		prevSlewL13,
		prevSampR13,
		prevSlewR13,
		prevSampL14,
		prevSlewL14,
		prevSampR14,
		prevSlewR14,
		prevSampL15,
		prevSlewL15,
		prevSampR15,
		prevSlewR15,
		prevSampL16,
		prevSlewL16,
		prevSampR16,
		prevSlewR16,
		pear_total
	}; //fixed frequency pear filter for ultrasonics, stereo
	double pear[pear_total]; //probably worth just using a number here
	
	double freqA;
	double freqB;
	double nonLinA;
	double nonLinB;
	double wetA;
	double wetB;

    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
