/* ========================================
 *  Pressure4 - Pressure4.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Pressure4.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Pressure4 {

Pressure4::Pressure4()
{
	A = 0.0;
	B = 0.2;
	C = 1.0;
	D = 1.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	muSpeedA = 10000;
	muSpeedB = 10000;
	muCoefficientA = 1;
	muCoefficientB = 1;
	muVary = 1;
	flip = false;	
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Pressure4::getParameterCount() const
{
  return kNumParameters;
}

void Pressure4::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break; //percent. Using this value, it'll be 0-100 everywhere
        case kParamC: C = value; break; //this is the popup, stored as a float
        case kParamD: D = value; break; //this is the popup, stored as a float
        default: break; // unknown parameter, shouldn't happen!
    }
	//we can also set other defaults here, and do calculations that only have to happen
	//once when parameters actually change. Here is the 'popup' setting its (global) values.
	//variables can also be set in the processreplacing loop, and there they'll be set every buffersize
	//here they're set when a parameter's actually changed, which should be less frequent, but
	//you must use global variables in the Pressure4.h file to do it.
}

float Pressure4::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
		case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Pressure4::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Pressure", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Speed", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Mewiness", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Output Gain", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Pressure4::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break; //also display 0-1 as percent
        case kParamC: float2string ((C*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Pressure4::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break; //the percent
        case kParamC: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, " ", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
