/* ========================================
 *  PurestAir - PurestAir.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __PurestAir_PurestAir_H
#define __PurestAir_PurestAir_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::PurestAir {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class PurestAir final : public SfxCoreExtensionV1
{
public:
    PurestAir();
    ~PurestAir();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double last1SampleL;
	double halfwaySampleL;
	double halfDrySampleL;
	double halfDiffSampleL;
	double diffSampleL;
	double lastSampleL;
	double s1L;
	double s2L;
	double s3L;
	double applyL;

	double last1SampleR;
	double halfwaySampleR;
	double halfDrySampleR;
	double halfDiffSampleR;
	double diffSampleR;
	double lastSampleR;
	double s1R;
	double s2R;
	double s3R;
	double applyR;
	
    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
