/* ========================================
 *  Pyewacket - Pyewacket.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Pyewacket.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Pyewacket {

Pyewacket::Pyewacket()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	chase = 1.0;
	lastrectifierL = 0.0;
	lastrectifierR = 0.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Pyewacket::getParameterCount() const
{
  return kNumParameters;
}

void Pyewacket::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Pyewacket::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Pyewacket::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Input Gain", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Release", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Output Gain", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Pyewacket::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*24.0)-12.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string ((C*24.0)-12.0, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Pyewacket::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break; //the percent
        case kParamC: strncpy (text, "dB", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
