/* ========================================
 *  ResEQ - ResEQ.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "ResEQ.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::ResEQ {

ResEQ::ResEQ()
{
	A = 0.0;
	B = 0.0;
	C = 0.0;
	D = 0.0;
	E = 0.0;
	F = 0.0;
	G = 0.0;
	H = 0.0;
	I = 0.0;
	for(int count = 0; count < 60; count++) {
		bL[count] = 0.0; fL[count] = 0.0;
		bR[count] = 0.0; fR[count] = 0.0;
	}
	framenumber = 0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int ResEQ::getParameterCount() const
{
  return kNumParameters;
}

void ResEQ::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
		case kParamF: F = value; break;
		case kParamG: G = value; break;
		case kParamH: H = value; break;
		case kParamI: I = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float ResEQ::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        case kParamG: return G; break;
        case kParamH: return H; break;
        case kParamI: return I; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void ResEQ::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Reso 1", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Reso 2", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Reso 3", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Reso 4", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Reso 5", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Reso 6", kVstMaxParamStrLen); break;
		case kParamG: strncpy (text, "Reso 7", kVstMaxParamStrLen); break;
		case kParamH: strncpy (text, "Reso 8", kVstMaxParamStrLen); break;
		case kParamI: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void ResEQ::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        case kParamF: float2string (F, text, kVstMaxParamStrLen); break;
        case kParamG: float2string (G, text, kVstMaxParamStrLen); break;
        case kParamH: float2string (H, text, kVstMaxParamStrLen); break;
        case kParamI: float2string (I, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void ResEQ::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamG: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamH: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamI: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
