/* ========================================
 *  Srsly - Srsly.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Srsly_Srsly_H
#define __Srsly_Srsly_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Srsly {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
  kNumParameters = 5
}; //


class Srsly final : public SfxCoreExtensionV1
{
public:
    Srsly();
    ~Srsly();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double biquadM2[11];
	double biquadM7[11];
	double biquadM10[11];
	
	double biquadL3[11];
	double biquadL7[11];
	double biquadR3[11];
	double biquadR7[11];
	
	double biquadS3[11];
	double biquadS5[11];

	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
