/* ========================================
 *  Srsly3 - Srsly3.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Srsly3_Srsly3_H
#define __Srsly3_Srsly3_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Srsly3 {
enum {
	kParamA =0,
	kParamB =1,
	kParamC =2,
	kParamD =3,
	kParamE =4,
	kParamF =5,
  kNumParameters = 6
}; //


class Srsly3 final : public SfxCoreExtensionV1
{
public:
    Srsly3();
    ~Srsly3();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
	
	double biquadM2[9];
	double biquadM7[9];
	double biquadM10[9];
	
	double biquadL3[9]; //note that this isn't the stereo
	double biquadL7[9]; //form of the biquad, like it's set
	double biquadR3[9]; //up to be. The M/S parts don't lend
	double biquadR7[9]; //themselves to that
	
	double biquadS3[9];
	double biquadS5[9];
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
