/* ========================================
 *  StereoEnsemble - StereoEnsemble.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __StereoEnsemble_StereoEnsemble_H
#define __StereoEnsemble_StereoEnsemble_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::StereoEnsemble {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class StereoEnsemble final : public SfxCoreExtensionV1
{
public:
    StereoEnsemble();
    ~StereoEnsemble();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
	
	double dA[7491];
	double dB[7533];
	double dC[5789];
	double dD[5747];		
	double dE[4841];
	double dF[4871];
	double dG[3119];
	double dH[3089];
	double dI[2213];
	double dJ[2223];
	double dK[1337];
	double dL[1331];
	
	double levelA;
	double levelB;
	double levelC;
	double levelD;
	double levelE;
	double levelF;
	
	double levelG;
	double levelH;
	double levelI;
	double levelJ;
	double levelK;
	double levelL;
	
	double dryL;
	double dryR;
	
	int oneA, maxdelayA;
	int oneB, maxdelayB;
	int oneC, maxdelayC;
	int oneD, maxdelayD;
	int oneE, maxdelayE;
	int oneF, maxdelayF;
	
	int oneG, maxdelayG;
	int oneH, maxdelayH;
	int oneI, maxdelayI;
	int oneJ, maxdelayJ;
	int oneK, maxdelayK;
	int oneL, maxdelayL;
	
	double lastRefL[7];
	double lastRefR[7];
	int cycle;
	    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
