/* ========================================
 *  StudioTan - StudioTan.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "StudioTan.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::StudioTan {

StudioTan::StudioTan()
{
	A = 0.0;

	bynL[0] = 1000.0;
	bynL[1] = 301.0;
	bynL[2] = 176.0;
	bynL[3] = 125.0;
	bynL[4] = 97.0;
	bynL[5] = 79.0;
	bynL[6] = 67.0;
	bynL[7] = 58.0;
	bynL[8] = 51.0;
	bynL[9] = 46.0;
	bynL[10] = 1000.0;
	noiseShapingL = 0.0;
	lastSampleL = 0.0;
	lastSample2L = 0.0;

	bynR[0] = 1000.0;
	bynR[1] = 301.0;
	bynR[2] = 176.0;
	bynR[3] = 125.0;
	bynR[4] = 97.0;
	bynR[5] = 79.0;
	bynR[6] = 67.0;
	bynR[7] = 58.0;
	bynR[8] = 51.0;
	bynR[9] = 46.0;
	bynR[10] = 1000.0;
	noiseShapingR = 0.0;
	lastSampleR = 0.0;
	lastSample2R = 0.0;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int StudioTan::getParameterCount() const
{
  return kNumParameters;
}

void StudioTan::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float StudioTan::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void StudioTan::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Quantzr", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void StudioTan::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 5.999 )) //0 to almost edge of # of params
		{case 0: strncpy (text, "ST 24", kVstMaxParamStrLen); break;
		 case 1: strncpy (text, "DMT 24", kVstMaxParamStrLen); break;
		 case 2: strncpy (text, "NJAD 24", kVstMaxParamStrLen); break;
		 case 3: strncpy (text, "ST 16", kVstMaxParamStrLen); break;
		 case 4: strncpy (text, "DMT 16", kVstMaxParamStrLen); break;
		 case 5: strncpy (text, "NJAD 16", kVstMaxParamStrLen); break;
		 default: break; // unknown parameter, shouldn't happen!
		} break; //E as example 'popup' parameter with four values  */
			
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void StudioTan::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
