/* ========================================
 *  Surge - Surge.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Surge.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Surge {

Surge::Surge()
{
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	flip = true;
	chaseA = 0.0;
	chaseB = 0.0;
	chaseC = 0.0;	
	chaseD = 0.0;	
	chaseMax = 0.0;	
	A = 0.0;
	B = 1.0;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Surge::getParameterCount() const
{
  return kNumParameters;
}

void Surge::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break; //percent. Using this value, it'll be 0-100 everywhere
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Surge::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Surge::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Surge", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Surge::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break; //also display 0-1 as percent
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Surge::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break; //the percent
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
