/* ========================================
 *  TapeDelay2 - TapeDelay2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __TapeDelay2_TapeDelay2_H
#define __TapeDelay2_TapeDelay2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::TapeDelay2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
  kNumParameters = 6
}; //


class TapeDelay2 final : public SfxCoreExtensionV1
{
public:
    TapeDelay2();
    ~TapeDelay2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	
	double dL[88211];
	double prevSampleL;
	double delayL;
	double sweepL;
	double regenFilterL[9];
	double outFilterL[9];
	double lastRefL[10];
	
	double dR[88211];
	double prevSampleR;
	double delayR;
	double sweepR;
	double regenFilterR[9];
	double outFilterR[9];
	double lastRefR[10];
	
	int cycle;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
